/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.geotools.factory.Hints;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;

public class MapPropertyAccessorFactory
implements PropertyAccessorFactory {
    private static PropertyAccessor MAP_ACCESSOR = new PropertyAccessor(){

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Map;
        }

        public Object get(Object object, String xpath, Class target) throws IllegalArgumentException {
            JXPathContext context = JXPathContext.newContext((Object)object);
            context.setLenient(true);
            Object value = context.getValue(xpath);
            return value;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException, IllegalArgumentException {
            throw new IllegalAttributeException("not implemented");
        }
    };

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (Map.class.isAssignableFrom(type)) {
            return MAP_ACCESSOR;
        }
        return null;
    }
}

