/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAttributeExpression
extends AttributeExpressionImpl {
    private final List<Expression> expressions;
    private Hints namespaces;
    private CoordinateReferenceSystem crs;

    public NestedAttributeExpression(String xpath, List<Expression> expressions) {
        super(xpath);
        if (expressions == null || expressions.size() <= 1 || expressions.size() % 2 != 0) {
            throw new UnsupportedOperationException("Unmapping nested filter expressions fail!");
        }
        this.expressions = expressions;
    }

    public NestedAttributeExpression(String xpath, CoordinateReferenceSystem reprojection) {
        super(xpath);
        this.expressions = Collections.emptyList();
        this.crs = reprojection;
    }

    public Object evaluate(Object object) {
        Collection<Object> valueList;
        if (object == null) {
            return null;
        }
        if (!(object instanceof Feature)) {
            throw new UnsupportedOperationException("Expecting a feature to apply filter, but found: " + object);
        }
        ArrayList<Feature> rootList = new ArrayList<Feature>();
        rootList.add((Feature)object);
        FeatureTypeMapping mappings = null;
        String[] xPathSteps = this.attPath.split("/");
        if (!this.expressions.isEmpty()) {
            Expression expression = this.expressions.get(0);
            Object value = expression.evaluate((Object)((Feature)object));
            assert (value instanceof Name);
            try {
                mappings = AppSchemaDataAccessRegistry.getMapping((Name)value);
                this.namespaces = new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)mappings.getNamespaces());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Mapping not found for: '" + value + "' type!");
            }
        } else if (xPathSteps.length > 1) {
            throw new UnsupportedOperationException("Filtering deep complex attributes straight on complex features aren't supported yet.");
        }
        if ((valueList = this.evaluate(rootList, 1, mappings, xPathSteps)).isEmpty()) {
            return null;
        }
        String valueString = valueList.toString();
        return valueString.substring(1, valueString.length() - 1);
    }

    private Expression getExpression(int stepIndex, String[] xPathSteps) {
        return stepIndex < this.expressions.size() ? this.expressions.get(stepIndex) : new AttributeExpressionImpl(xPathSteps[stepIndex - 1], this.namespaces);
    }

    private Collection<Object> evaluate(Collection<Feature> rootList, int stepIndex, FeatureTypeMapping mappings, String[] xPathSteps) {
        HashSet<Object> valueList = new HashSet<Object>();
        if (stepIndex >= this.expressions.size() && stepIndex > xPathSteps.length) {
            return Collections.emptyList();
        }
        Expression expression = this.getExpression(stepIndex, xPathSteps);
        for (Feature root : rootList) {
            HashSet<Object> attributeValues = new HashSet<Object>();
            Object value = expression.evaluate((Object)root);
            if (value == null) continue;
            if (value instanceof Attribute) {
                value = ((Attribute)value).getValue();
            }
            if (value == null) continue;
            if (value instanceof Collection) {
                for (Object val : (Collection)value) {
                    if (val instanceof Attribute) {
                        val = ((Attribute)val).getValue();
                    }
                    attributeValues.add(val);
                }
            } else {
                attributeValues.add(value);
            }
            if (stepIndex <= xPathSteps.length && mappings != null) {
                AttributeMapping mapping = mappings.getAttributeMapping(XPath.steps(mappings.getTargetFeature(), xPathSteps[stepIndex - 1], mappings.getNamespaces()));
                if (!(stepIndex < this.expressions.size() - 1 || mapping != null && mapping instanceof NestedAttributeMapping)) {
                    if (attributeValues.isEmpty()) continue;
                    valueList.addAll(attributeValues);
                    continue;
                }
                if (mapping == null) {
                    throw new UnsupportedOperationException("Mapping not found for: '" + xPathSteps[stepIndex].toString() + "'");
                }
                assert (mapping instanceof NestedAttributeMapping);
                FeatureTypeMapping fMapping = null;
                try {
                    ArrayList<Feature> featureList = this.getFeatures((NestedAttributeMapping)mapping, attributeValues);
                    ++stepIndex;
                    if (featureList.isEmpty()) continue;
                    if (stepIndex < this.expressions.size() - 1) {
                        Expression nextExpression = this.expressions.get(stepIndex);
                        value = nextExpression.evaluate((Object)featureList.get(0));
                        assert (value instanceof Name);
                        try {
                            fMapping = AppSchemaDataAccessRegistry.getMapping((Name)value);
                            this.namespaces = new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)fMapping.getNamespaces());
                        }
                        catch (IOException e) {
                            throw new UnsupportedOperationException("Mapping not found for: '" + value + "' type!");
                        }
                    }
                    valueList.addAll(this.evaluate(featureList, ++stepIndex, fMapping, xPathSteps));
                    continue;
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("Nested feature not found while filtering nested attribute: '" + Arrays.toString(this.expressions.toArray()) + "' cause :" + e.getMessage());
                }
            }
            if (attributeValues.isEmpty()) continue;
            valueList.addAll(attributeValues);
        }
        return valueList;
    }

    private ArrayList<Feature> getFeatures(NestedAttributeMapping mapping, Collection<Object> foreignKeys) throws IOException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        boolean hasSimpleFeatures = AppSchemaDataAccessRegistry.hasName(mapping.getNestedFeatureType());
        if (hasSimpleFeatures) {
            for (Object val : foreignKeys) {
                featureList.addAll(mapping.getInputFeatures(val, this.crs));
            }
        } else {
            for (Object val : foreignKeys) {
                featureList.addAll(mapping.getFeatures(val, this.crs));
            }
        }
        return featureList;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof NestedAttributeExpression)) {
            return false;
        }
        return ((Object)this.expressions).equals(((NestedAttributeExpression)((Object)o)).getExpressions());
    }
}

