/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public class TimeSeriesStressTest
extends OnlineTestCase {
    private static final Logger LOGGER = Logging.getLogger((String)TimeSeriesStressTest.class.getPackage().getName());
    private static final String AWNS = "http://www.water.gov.au/awdip";
    private static final String CVNS = "http://www.opengis.net/cv/0.2.1";
    private static final String SANS = "http://www.opengis.net/sampling/1.0";
    private static final String OMNS = "http://www.opengis.net/om/1.0";
    private static final String SWENS = "http://www.opengis.net/swe/1.0.1";
    private static final String GMLNS = "http://www.opengis.net/gml";
    final String schemaBase = "/test-data/";
    EmfAppSchemaReader reader;
    private FeatureSource<FeatureType, Feature> source;

    protected String getFixtureId() {
        return "app-schema.TimeSeriesStressTest";
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reader = EmfAppSchemaReader.newInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void loadSchema(String location) throws IOException {
        URL schemaLocation = ((Object)((Object)this)).getClass().getResource(location);
        if (schemaLocation == null) {
            schemaLocation = new URL(location);
        }
        TimeSeriesStressTest.assertNotNull((String)location, (Object)schemaLocation);
        this.reader.parse(schemaLocation, null);
    }

    private Name name(String ns, String localName) {
        return Types.typeName((String)ns, (String)localName);
    }

    public void testStressDataStore() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        String configLocation = "/test-data/TimeSeriesTest_properties2.xml";
        URL url = ((Object)((Object)this)).getClass().getResource(configLocation);
        dsParams.put("dbtype", "complex");
        dsParams.put("url", url.toExternalForm());
        NameImpl typeName = new NameImpl(AWNS, "SiteSinglePhenomTimeSeries");
        DataAccess mappingDataStore = DataAccessFinder.getDataStore(dsParams);
        TimeSeriesStressTest.assertNotNull((Object)mappingDataStore);
        FeatureType fType = mappingDataStore.getSchema((Name)typeName);
        TimeSeriesStressTest.assertNotNull((Object)fType);
        FeatureSource fSource = mappingDataStore.getFeatureSource((Name)typeName);
        Filter filter = CQL.toFilter((String)"gml:name = 'stat_id_3000'");
        FeatureCollection features = fSource.getFeatures(filter);
        int expectedResults = 3000;
        boolean EXPECTED_RESULT_COUNT = true;
        int numberOfRuns = 5;
        double countTime = this.stressCount(features, 1, 5);
        LOGGER.info("getCount() agv time: " + countTime + "ms");
        LOGGER.info("Stressing getFeatures()...");
        double fetchTime = this.stressGetFeatures(features, 1, 5, 3000);
        LOGGER.info("getFeatures() agv time: " + fetchTime + "ms");
    }

    private double stressGetFeatures(FeatureCollection features, int EXPECTED_RESULT_COUNT, int numberOfRuns, int expectedResults) {
        double cumulativeTime = 0.0;
        StopWatch timer = new StopWatch();
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("aw", AWNS);
        namespaces.declarePrefix("om", OMNS);
        namespaces.declarePrefix("swe", SWENS);
        namespaces.declarePrefix("gml", GMLNS);
        namespaces.declarePrefix("sa", SANS);
        FilterFactoryImplNamespaceAware ffac = new FilterFactoryImplNamespaceAware(namespaces);
        Feature feature = null;
        int count = 0;
        String phenomNamePath = "aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name";
        for (int run = 0; run < numberOfRuns; ++run) {
            Iterator it = features.iterator();
            count = 0;
            timer.start();
            while (it.hasNext()) {
                feature = (Feature)it.next();
                ++count;
            }
            timer.stop();
            cumulativeTime += (double)timer.time();
            features.close(it);
        }
        PropertyName gmlName = ffac.property("gml:name");
        PropertyName phenomName = ffac.property("aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name");
        Object nameVal = gmlName.evaluate(feature, String.class);
        TimeSeriesStressTest.assertNotNull((String)"gml:name evaluated to null", (Object)nameVal);
        Object phenomNameVal = phenomName.evaluate((Object)feature, String.class);
        TimeSeriesStressTest.assertNotNull((String)"aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name evaluated to null", (Object)phenomNameVal);
        PropertyName sampledFeatureName = ffac.property("sa:sampledFeature");
        Attribute sampledFeatureVal = (Attribute)sampledFeatureName.evaluate((Object)feature);
        TimeSeriesStressTest.assertNotNull((String)"sa:sampledFeature evaluated to null", (Object)sampledFeatureVal);
        TimeSeriesStressTest.assertNull((Object)sampledFeatureVal.getValue());
        Map attributes = (Map)sampledFeatureVal.getUserData().get(Attributes.class);
        TimeSeriesStressTest.assertNotNull((Object)attributes);
        Name xlinkTitle = this.name("http://www.w3.org/1999/xlink", "title");
        TimeSeriesStressTest.assertTrue((boolean)attributes.containsKey(xlinkTitle));
        TimeSeriesStressTest.assertNotNull(attributes.get(xlinkTitle));
        Name xlinkHref = this.name("http://www.w3.org/1999/xlink", "href");
        TimeSeriesStressTest.assertTrue((boolean)attributes.containsKey(xlinkHref));
        TimeSeriesStressTest.assertNotNull(attributes.get(xlinkHref));
        TimeSeriesStressTest.assertEquals((int)EXPECTED_RESULT_COUNT, (int)count);
        PropertyName elementName = ffac.property("aw:relatedObservation/aw:PhenomenonTimeSeries/om:result/cv:CompactDiscreteTimeCoverage");
        Object timeCovVal = elementName.evaluate((Object)feature);
        TimeSeriesStressTest.assertNotNull((String)"aw:relatedObservation/aw:PhenomenonTimeSeries/om:result/cv:CompactDiscreteTimeCoverage", (Object)timeCovVal);
        TimeSeriesStressTest.assertTrue((boolean)(timeCovVal instanceof Feature));
        List elements = (List)((Feature)timeCovVal).getValue();
        TimeSeriesStressTest.assertEquals((int)expectedResults, (int)elements.size());
        ComplexAttribute element = (ComplexAttribute)elements.get(10);
        TimeSeriesStressTest.assertNotNull((Object)element);
        Name compactTimeValuePairName = Types.typeName((String)CVNS, (String)"CompactTimeValuePair");
        Name geometryName = Types.typeName((String)CVNS, (String)"geometry");
        Name valueName = Types.typeName((String)CVNS, (String)"value");
        Collection compactTimes = element.getProperties(compactTimeValuePairName);
        TimeSeriesStressTest.assertNotNull((Object)compactTimes);
        TimeSeriesStressTest.assertEquals((int)1, (int)compactTimes.size());
        ComplexAttribute compatTimeValuePair = (ComplexAttribute)compactTimes.iterator().next();
        Collection geometries = compatTimeValuePair.getProperties(geometryName);
        Collection values = compatTimeValuePair.getProperties(valueName);
        TimeSeriesStressTest.assertNotNull((Object)geometries);
        TimeSeriesStressTest.assertNotNull((Object)values);
        TimeSeriesStressTest.assertEquals((int)1, (int)geometries.size());
        TimeSeriesStressTest.assertEquals((int)1, (int)values.size());
        Attribute geom = (Attribute)geometries.iterator().next();
        Attribute value = (Attribute)values.iterator().next();
        TimeSeriesStressTest.assertNotNull((Object)geom.getValue());
        TimeSeriesStressTest.assertNotNull((Object)value.getValue());
        TimeSeriesStressTest.assertNotNull(value.getUserData().get(Attributes.class));
        return cumulativeTime / (double)numberOfRuns;
    }

    private double stressCount(FeatureCollection features, int expectedFeatureCount, int numberOfCycles) {
        double cumulativeTime = 0.0;
        StopWatch timer = new StopWatch();
        for (int i = 0; i < numberOfCycles; ++i) {
            timer.start();
            int size = features.size();
            timer.stop();
            TimeSeriesStressTest.assertEquals((int)expectedFeatureCount, (int)size);
            String msg = "be sure difference in result count is not due to different dataset.";
            TimeSeriesStressTest.assertEquals((String)msg, (int)expectedFeatureCount, (int)size);
        }
        return cumulativeTime / (double)numberOfCycles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount(FeatureCollection features) {
        Iterator iterator = features.iterator();
        int count = 0;
        try {
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        finally {
            features.close(iterator);
        }
        return count;
    }

    private static void populateTable() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PostgisDataStoreFactory.DBTYPE.key, "postgis");
        params.put(PostgisDataStoreFactory.DATABASE.key, "postgis");
        params.put(PostgisDataStoreFactory.HOST.key, "localhost");
        params.put(PostgisDataStoreFactory.PORT.key, "5432");
        params.put(PostgisDataStoreFactory.USER.key, "postgres");
        params.put(PostgisDataStoreFactory.PASSWD.key, "postgres");
        DataStore ds = DataStoreFinder.getDataStore(params);
        String typeSpec = "station_id:String,POSITION:Point,station_name:String,determinand_code:String,determinand_description:String,sample_time_position:java.util.Date,result:Double,units:String";
        SimpleFeatureType schema = DataUtilities.createType((String)"TimeSeriesTest", (String)"station_id:String,POSITION:Point,station_name:String,determinand_code:String,determinand_description:String,sample_time_position:java.util.Date,result:Double,units:String");
        LOGGER.info("Creating schema " + schema);
        ds.createSchema((FeatureType)schema);
        String station_id = "stat_id_1000";
        String determinand_code = "det_code_1000";
        TimeSeriesStressTest.populate(ds, schema, station_id, determinand_code, 1000);
        station_id = "stat_id_2000";
        determinand_code = "det_code_2000";
        TimeSeriesStressTest.populate(ds, schema, station_id, determinand_code, 2000);
        station_id = "stat_id_3000";
        determinand_code = "det_code_3000";
        TimeSeriesStressTest.populate(ds, schema, station_id, determinand_code, 3000);
        station_id = "stat_id_4000";
        determinand_code = "det_code_4000";
        TimeSeriesStressTest.populate(ds, schema, station_id, determinand_code, 4000);
        station_id = "stat_id_12000";
        determinand_code = "det_code_12000";
        TimeSeriesStressTest.populate(ds, schema, station_id, determinand_code, 12000);
    }

    private static void populate(DataStore ds, SimpleFeatureType schema, String station_id, String determinand_code, int featureCount) throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LOGGER.info("Creating " + featureCount + " features for station_id " + station_id);
        DefaultTransaction transaction = new DefaultTransaction();
        FeatureWriter fw = ds.getFeatureWriterAppend(schema.getTypeName(), (Transaction)transaction);
        for (double i = 0.0; i < (double)featureCount; i += 1.0) {
            fw.hasNext();
            SimpleFeature feature = (SimpleFeature)fw.next();
            feature.setAttribute("station_id", (Object)station_id);
            feature.setAttribute("determinand_code", (Object)determinand_code);
            feature.setAttribute("POSITION", (Object)gf.createPoint(new Coordinate(i / 1000.0, i / 1000.0)));
            feature.setAttribute("station_name", (Object)("stat_name_" + i));
            feature.setAttribute("determinand_description", (Object)("determinand description " + i + " for " + station_id));
            feature.setAttribute("sample_time_position", (Object)new Date());
            feature.setAttribute("result", (Object)new Double(i / 1000.0));
            fw.write();
            if (i % 100.0 != 0.0) continue;
            transaction.commit();
        }
        transaction.commit();
        fw.close();
        LOGGER.info(featureCount + " features added for " + station_id);
    }

    public static void main(String[] argv) {
        try {
            TimeSeriesStressTest.populateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class StopWatch {
        private long start;
        private long end = Long.MIN_VALUE;

        private StopWatch() {
        }

        public void start() {
            this.start = System.currentTimeMillis();
            this.end = Long.MIN_VALUE;
        }

        public void stop() {
            this.end = System.currentTimeMillis();
        }

        public long time() {
            if (Long.MIN_VALUE == this.end) {
                throw new IllegalStateException("call stop() before time()");
            }
            return this.end - this.start;
        }
    }
}

