/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.xml.resolver.Catalog;
import org.eclipse.xsd.XSDSchema;
import org.geotools.data.complex.config.CatalogUtilities;
import org.geotools.xml.SchemaLocationResolver;

public class CatalogSchemaLocationResolverWrapper
extends SchemaLocationResolver {
    private final Catalog catalog;
    private SchemaLocationResolver resolver;

    public CatalogSchemaLocationResolverWrapper(Catalog catalog, SchemaLocationResolver resolver) {
        super(null);
        this.catalog = catalog;
        this.resolver = resolver;
    }

    public String resolveSchemaLocation(XSDSchema schema, String uri, String location) {
        String schemaLocation = CatalogUtilities.resolveSchemaLocation(this.catalog, location);
        if (schemaLocation != null) {
            return CatalogSchemaLocationResolverWrapper.canonicalLocation(schemaLocation);
        }
        return CatalogSchemaLocationResolverWrapper.canonicalLocation(this.resolver.resolveSchemaLocation(schema, uri, location));
    }

    public boolean canHandle(XSDSchema schema, String uri, String location) {
        return this.resolveSchemaLocation(schema, uri, location) != null;
    }

    public String toString() {
        return this.resolver.toString();
    }

    static String canonicalLocation(String schemaLocation) {
        if (schemaLocation != null) {
            try {
                File file;
                URI uri = new URI(schemaLocation);
                if (uri.getScheme().equals("file") && (file = new File(uri.getPath())).exists()) {
                    return file.getCanonicalFile().toURI().toString();
                }
            }
            catch (URISyntaxException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return schemaLocation;
    }
}

