/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.CatalogUtilities;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.gml3.GML;
import org.geotools.util.logging.Logging;
import org.geotools.xml.SchemaIndex;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public class TimeSeriesTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)TimeSeriesTest.class.getPackage().getName());
    private static final String AWNS = "http://www.water.gov.au/awdip";
    private static final String CVNS = "http://www.opengis.net/cv/0.2.1";
    private static final String SANS = "http://www.opengis.net/sampling/1.0";
    private static final String OMNS = "http://www.opengis.net/om/1.0";
    private static final String SWENS = "http://www.opengis.net/swe/1.0.1";
    private static final String GMLNS = "http://www.opengis.net/gml";
    final String schemaBase = "/test-data/";
    EmfAppSchemaReader reader;
    private FeatureSource<FeatureType, Feature> source;

    protected void setUp() throws Exception {
        super.setUp();
        this.reader = EmfAppSchemaReader.newInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private SchemaIndex loadSchema(URL location) throws IOException {
        URL catalogLocation = ((Object)((Object)this)).getClass().getResource("/test-data/observations.oasis.xml");
        this.reader.setCatalog(CatalogUtilities.buildPrivateCatalog((URL)catalogLocation));
        return this.reader.parse(location, null);
    }

    public void testParseSchema() throws Exception {
        SchemaIndex schemaIndex;
        try {
            String schemaLocation = "/test-data/commonSchemas_new/awdip.xsd";
            URL location = ((Object)((Object)this)).getClass().getResource(schemaLocation);
            TimeSeriesTest.assertNotNull((Object)location);
            schemaIndex = this.loadSchema(location);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        FeatureTypeRegistry typeRegistry = new FeatureTypeRegistry();
        typeRegistry.addSchemas(schemaIndex);
        Name typeName = Types.typeName((String)AWNS, (String)"SiteSinglePhenomTimeSeriesType");
        ComplexType testType = (ComplexType)typeRegistry.getAttributeType(typeName);
        TimeSeriesTest.assertNotNull((Object)testType);
        TimeSeriesTest.assertTrue((boolean)(testType instanceof FeatureType));
        AttributeType superType = testType.getSuper();
        TimeSeriesTest.assertNotNull((Object)superType);
        Name superTypeName = Types.typeName((String)AWNS, (String)"SamplingSitePurposeType");
        TimeSeriesTest.assertEquals((Object)superTypeName, (Object)superType.getName());
        HashMap<Name, Name> samplingProperties = new HashMap<Name, Name>();
        samplingProperties.put(this.name(GMLNS, "metaDataProperty"), this.typeName(GMLNS, "MetaDataPropertyType"));
        samplingProperties.put(this.name(GMLNS, "description"), this.typeName(GMLNS, "StringOrRefType"));
        samplingProperties.put(this.name(GMLNS, "name"), this.typeName(GMLNS, "CodeType"));
        samplingProperties.put(this.name(GMLNS, "boundedBy"), this.typeName(GMLNS, "BoundingShapeType"));
        samplingProperties.put(this.name(GMLNS, "location"), this.typeName(GMLNS, "LocationPropertyType"));
        samplingProperties.put(this.name(AWNS, "samplingRegimeType"), Types.toTypeName((QName)GML.CodeType));
        samplingProperties.put(this.name(AWNS, "waterBodyType"), Types.toTypeName((QName)GML.CodeType));
        samplingProperties.put(this.name(AWNS, "accessTypeCode"), Types.toTypeName((QName)GML.CodeType));
        samplingProperties.put(this.name(SANS, "position"), this.typeName(GMLNS, "PointPropertyType"));
        samplingProperties.put(this.name(SANS, "relatedObservation"), this.typeName(OMNS, "ObservationPropertyType"));
        samplingProperties.put(this.name(SANS, "relatedSamplingFeature"), this.typeName(SANS, "SamplingFeatureRelationPropertyType"));
        samplingProperties.put(this.name(SANS, "sampledFeature"), this.typeName(GMLNS, "FeaturePropertyType"));
        samplingProperties.put(this.name(SANS, "surveyDetails"), this.typeName(SANS, "SurveyProcedurePropertyType"));
        samplingProperties.put(this.name(AWNS, "relatedObservation"), this.typeName(AWNS, "PhenomenonTimeSeriesPropertyType"));
        this.assertPropertyNamesAndTypeNames(testType, samplingProperties);
        AttributeDescriptor relatedObservation = (AttributeDescriptor)Types.descriptor((ComplexType)testType, (Name)this.name(AWNS, "relatedObservation"));
        HashMap<Name, Name> relatedObsProps = new HashMap<Name, Name>();
        relatedObsProps.put(this.name(AWNS, "PhenomenonTimeSeries"), this.typeName(AWNS, "PhenomenonTimeSeriesType"));
        ComplexType phenomenonTimeSeriesPropertyType = (ComplexType)relatedObservation.getType();
        this.assertPropertyNamesAndTypeNames(phenomenonTimeSeriesPropertyType, relatedObsProps);
        AttributeDescriptor phenomenonTimeSeries = (AttributeDescriptor)Types.descriptor((ComplexType)phenomenonTimeSeriesPropertyType, (Name)this.name(AWNS, "PhenomenonTimeSeries"));
        ComplexType phenomenonTimeSeriesType = (ComplexType)phenomenonTimeSeries.getType();
        HashMap<Name, Name> phenomenonTimeSeriesProps = new HashMap<Name, Name>();
        phenomenonTimeSeriesProps.put(this.name(AWNS, "result"), this.typeName(CVNS, "CompactDiscreteTimeCoveragePropertyType"));
        this.assertPropertyNamesAndTypeNames(phenomenonTimeSeriesType, phenomenonTimeSeriesProps);
        AttributeDescriptor observedProperty = (AttributeDescriptor)Types.descriptor((ComplexType)phenomenonTimeSeriesType, (Name)this.name(OMNS, "observedProperty"));
        ComplexType phenomenonPropertyType = (ComplexType)observedProperty.getType();
        this.assertPropertyNamesAndTypeNames(phenomenonPropertyType, Collections.singletonMap(this.name(SWENS, "Phenomenon"), this.typeName(SWENS, "PhenomenonType")));
        AttributeDescriptor phenomenon = (AttributeDescriptor)Types.descriptor((ComplexType)phenomenonPropertyType, (Name)this.name(SWENS, "Phenomenon"));
        ComplexType phenomenonType = (ComplexType)phenomenon.getType();
        TimeSeriesTest.assertNotNull((Object)phenomenonType.getSuper());
        TimeSeriesTest.assertEquals((Object)this.typeName(GMLNS, "DefinitionType"), (Object)phenomenonType.getSuper().getName());
        HashMap<Name, Object> phenomenonProps = new HashMap<Name, Object>();
        phenomenonProps.put(this.name(GMLNS, "metaDataProperty"), null);
        phenomenonProps.put(this.name(GMLNS, "description"), null);
        phenomenonProps.put(this.name(GMLNS, "name"), null);
        this.assertPropertyNamesAndTypeNames(phenomenonType, phenomenonProps);
    }

    private void assertPropertyNamesAndTypeNames(ComplexType parentType, Map expectedPropertiesAndTypes) throws Exception {
        for (Map.Entry entry : expectedPropertiesAndTypes.entrySet()) {
            AttributeType type;
            Name dName = (Name)entry.getKey();
            Name expectedDescriptorTypeName = (Name)entry.getValue();
            AttributeDescriptor d = (AttributeDescriptor)Types.descriptor((ComplexType)parentType, (Name)dName);
            TimeSeriesTest.assertNotNull((String)("Descriptor " + dName + " not found for type " + parentType.getName()), (Object)d);
            try {
                type = d.getType();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "type not parsed for " + d.getName(), e);
                throw e;
            }
            TimeSeriesTest.assertNotNull((Object)type);
            Name actualTypeName = type.getName();
            TimeSeriesTest.assertNotNull((Object)actualTypeName);
            TimeSeriesTest.assertNotNull((Object)type.getBinding());
            if (expectedDescriptorTypeName == null) continue;
            TimeSeriesTest.assertEquals((String)("type mismatch for property " + dName), (Object)expectedDescriptorTypeName, (Object)actualTypeName);
        }
    }

    private Name typeName(String ns, String localName) {
        return Types.typeName((String)ns, (String)localName);
    }

    private Name name(String ns, String localName) {
        return Types.typeName((String)ns, (String)localName);
    }

    public void testLoadMappingsConfig() throws Exception {
        XMLConfigDigester reader = new XMLConfigDigester();
        String configLocation = "/test-data/TimeSeriesTest_properties.xml";
        URL url = ((Object)((Object)this)).getClass().getResource(configLocation);
        AppSchemaDataAccessDTO config = reader.parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        TimeSeriesTest.assertNotNull((Object)mappings);
        TimeSeriesTest.assertEquals((int)1, (int)mappings.size());
        FeatureTypeMapping mapping = (FeatureTypeMapping)mappings.iterator().next();
        AttributeDescriptor targetFeature = mapping.getTargetFeature();
        TimeSeriesTest.assertNotNull((Object)targetFeature);
        TimeSeriesTest.assertNotNull((Object)targetFeature.getType());
        TimeSeriesTest.assertEquals((String)AWNS, (String)targetFeature.getName().getNamespaceURI());
        TimeSeriesTest.assertEquals((String)"SiteSinglePhenomTimeSeries", (String)targetFeature.getName().getLocalPart());
        List attributeMappings = mapping.getAttributeMappings();
        AttributeMapping attMapping = (AttributeMapping)attributeMappings.get(0);
        TimeSeriesTest.assertNotNull((Object)attMapping);
        TimeSeriesTest.assertEquals((String)"aw:SiteSinglePhenomTimeSeries", (String)attMapping.getTargetXPath().toString());
        attMapping = (AttributeMapping)attributeMappings.get(1);
        TimeSeriesTest.assertNotNull((Object)attMapping);
        TimeSeriesTest.assertEquals((String)"gml:name[1]", (String)attMapping.getTargetXPath().toString());
        attMapping = (AttributeMapping)attributeMappings.get(2);
        TimeSeriesTest.assertNotNull((Object)attMapping);
        TimeSeriesTest.assertEquals((String)"sa:sampledFeature", (String)attMapping.getTargetXPath().toString());
        TimeSeriesTest.assertSame((Object)Expression.NIL, (Object)attMapping.getSourceExpression());
        TimeSeriesTest.assertSame((Object)Expression.NIL, (Object)attMapping.getIdentifierExpression());
        Map clientProperties = attMapping.getClientProperties();
        TimeSeriesTest.assertEquals((int)2, (int)clientProperties.size());
        Name clientPropName = this.name("http://www.w3.org/1999/xlink", "title");
        TimeSeriesTest.assertTrue((String)("client property " + clientPropName + " not found"), (boolean)clientProperties.containsKey(clientPropName));
        clientPropName = this.name("http://www.w3.org/1999/xlink", "href");
        TimeSeriesTest.assertTrue((String)("client property " + clientPropName + " not found"), (boolean)clientProperties.containsKey(clientPropName));
        attMapping = (AttributeMapping)attributeMappings.get(5);
        TimeSeriesTest.assertNotNull((Object)attMapping);
        String expected = "aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name";
        String actual = attMapping.getTargetXPath().toString();
        TimeSeriesTest.assertEquals((String)expected, (String)actual);
    }

    public void testDataStore() throws Exception {
        NameImpl typeName = new NameImpl(AWNS, "SiteSinglePhenomTimeSeries");
        HashMap<String, String> dsParams = new HashMap<String, String>();
        String configLocation = "/test-data/TimeSeriesTest_properties.xml";
        URL url = ((Object)((Object)this)).getClass().getResource(configLocation);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mappingDataStore = DataAccessFinder.getDataStore(dsParams);
        TimeSeriesTest.assertNotNull((Object)mappingDataStore);
        FeatureType fType = mappingDataStore.getSchema((Name)typeName);
        TimeSeriesTest.assertNotNull((Object)fType);
        FeatureSource fSource = mappingDataStore.getFeatureSource((Name)typeName);
        int EXPECTED_MAPPED_FEATURE_COUNT = 3;
        int EXPECTED_SIMPLE_FEATURE_COUNT = 96;
        FeatureCollection features = fSource.getFeatures();
        int resultCount = this.getCount(features);
        String msg = "be sure difference in result count is not due to different dataset.";
        TimeSeriesTest.assertEquals((String)msg, (int)3, (int)resultCount);
        int count = 0;
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("aw", AWNS);
        namespaces.declarePrefix("om", OMNS);
        namespaces.declarePrefix("swe", SWENS);
        namespaces.declarePrefix("gml", GMLNS);
        namespaces.declarePrefix("sa", SANS);
        namespaces.declarePrefix("cv", CVNS);
        FilterFactoryImplNamespaceAware ffac = new FilterFactoryImplNamespaceAware(namespaces);
        String phenomNamePath = "aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name";
        Iterator it = features.iterator();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            ++count;
            PropertyName gmlName = ffac.property("gml:name");
            PropertyName phenomName = ffac.property("aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name");
            Object nameVal = gmlName.evaluate((Object)feature, String.class);
            TimeSeriesTest.assertNotNull((String)"gml:name evaluated to null", (Object)nameVal);
            Object phenomNameVal = phenomName.evaluate((Object)feature, String.class);
            TimeSeriesTest.assertNotNull((String)"aw:relatedObservation/aw:PhenomenonTimeSeries/om:observedProperty/swe:Phenomenon/gml:name evaluated to null", (Object)phenomNameVal);
            PropertyName sampledFeatureName = ffac.property("sa:sampledFeature");
            Attribute sampledFeatureVal = (Attribute)sampledFeatureName.evaluate((Object)feature);
            TimeSeriesTest.assertNotNull((String)"sa:sampledFeature evaluated to null", (Object)sampledFeatureVal);
            TimeSeriesTest.assertEquals((int)0, (int)((Collection)sampledFeatureVal.getValue()).size());
            Map attributes = (Map)sampledFeatureVal.getUserData().get(Attributes.class);
            TimeSeriesTest.assertNotNull((Object)attributes);
            Name xlinkTitle = this.name("http://www.w3.org/1999/xlink", "title");
            TimeSeriesTest.assertTrue((boolean)attributes.containsKey(xlinkTitle));
            TimeSeriesTest.assertNotNull(attributes.get(xlinkTitle));
            Name xlinkHref = this.name("http://www.w3.org/1999/xlink", "href");
            TimeSeriesTest.assertTrue((boolean)attributes.containsKey(xlinkHref));
            TimeSeriesTest.assertNotNull(attributes.get(xlinkHref));
            String elementPath = "aw:relatedObservation/aw:PhenomenonTimeSeries/om:result/cv:CompactDiscreteTimeCoverage";
            PropertyName elementName = ffac.property("aw:relatedObservation/aw:PhenomenonTimeSeries/om:result/cv:CompactDiscreteTimeCoverage");
            Object timeCovVal = elementName.evaluate((Object)feature);
            TimeSeriesTest.assertNotNull((String)"aw:relatedObservation/aw:PhenomenonTimeSeries/om:result/cv:CompactDiscreteTimeCoverage", (Object)timeCovVal);
            TimeSeriesTest.assertTrue((boolean)(timeCovVal instanceof Feature));
            List elements = (List)((Feature)timeCovVal).getValue();
            TimeSeriesTest.assertEquals((int)1, (int)elements.size());
        }
        features.close(it);
        count = 0;
        Iterator simpleIterator = ((AbstractMappingFeatureIterator)features.iterator()).getSourceFeatureIterator();
        while (simpleIterator.hasNext()) {
            Feature feature = (Feature)simpleIterator.next();
            if (++count != 22) continue;
            String compactTimeValuePairName = "result";
            String geomName = "sample_time_position";
            Collection compactTimes = feature.getProperties(compactTimeValuePairName);
            TimeSeriesTest.assertNotNull((Object)compactTimes);
            TimeSeriesTest.assertEquals((int)1, (int)compactTimes.size());
            Attribute value = (Attribute)compactTimes.iterator().next();
            TimeSeriesTest.assertNotNull((Object)value.getValue());
            Collection geomProperties = feature.getProperties(geomName);
            TimeSeriesTest.assertNotNull((Object)geomProperties);
            TimeSeriesTest.assertEquals((int)1, (int)geomProperties.size());
            Attribute geom = (Attribute)geomProperties.iterator().next();
            TimeSeriesTest.assertNotNull((Object)geom.getValue());
            Object valueContent = geom.getValue();
            Date sampleTimePosition = (Date)valueContent;
            Calendar cal = Calendar.getInstance();
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.setTime(sampleTimePosition);
            TimeSeriesTest.assertEquals((int)2007, (int)cal.get(1));
            TimeSeriesTest.assertEquals((int)0, (int)cal.get(2));
            TimeSeriesTest.assertEquals((int)21, (int)cal.get(5));
            TimeSeriesTest.assertEquals((int)0, (int)cal.get(11));
            TimeSeriesTest.assertEquals((int)0, (int)cal.get(12));
            TimeSeriesTest.assertEquals((int)0, (int)cal.get(13));
        }
        mappingDataStore.dispose();
        TimeSeriesTest.assertEquals((int)96, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount(FeatureCollection features) {
        Iterator iterator = features.iterator();
        int count = 0;
        try {
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        finally {
            features.close(iterator);
        }
        return count;
    }
}

