/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.arcgrid;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.measure.unit.Unit;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ArcGridReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.arcgrid");
    private static final ImageReaderSpi readerSPI = new AsciiGridsImageReaderSpi();
    private double inNoData = Double.NaN;

    public ArcGridReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public ArcGridReader(Object input, Hints hints) throws DataSourceException {
        this.coverageName = "AsciiGrid";
        try {
            this.checkSource(input, hints);
            Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                LOGGER.log(Level.WARNING, new StringBuffer("Using forced coordinate reference system ").append(this.crs.toWKT()).toString());
            } else {
                this.getCoordinateReferenceSystem();
            }
            ImageReader reader = readerSPI.createReaderInstance();
            reader.setInput(this.inStream);
            IIOMetadata metadata = reader.getImageMetadata(0);
            if (!(metadata instanceof AsciiGridsImageMetadata)) {
                throw new DataSourceException("Unexpected error! Metadata are not of the expected class.");
            }
            AsciiGridsImageMetadata gridMetadata = (AsciiGridsImageMetadata)metadata;
            this.parseMetadata(gridMetadata);
            this.getResolutionInfo(reader);
            this.finalStreamPreparation();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private void finalStreamPreparation() throws IOException {
        if (this.closeMe) {
            this.inStream.close();
        } else {
            this.inStream.reset();
            this.inStream.mark();
        }
    }

    private void checkSource(Object input, Hints hints) throws UnsupportedEncodingException, DataSourceException, IOException, FileNotFoundException {
        URL sourceURL;
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            this.hints.add((RenderingHints)hints);
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (input == null) {
            DataSourceException ex = new DataSourceException("No source set to read this coverage.");
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            throw ex;
        }
        this.source = input;
        if (hints != null) {
            this.hints.add((RenderingHints)hints);
        }
        this.closeMe = true;
        if (input instanceof URL && (sourceURL = (URL)input).getProtocol().compareToIgnoreCase("file") == 0) {
            this.source = input = DataUtilities.urlToFile((URL)sourceURL);
        }
        if (input instanceof File) {
            File sourceFile = (File)input;
            if (!sourceFile.exists() || sourceFile.isDirectory() || !sourceFile.canRead()) {
                throw new DataSourceException("Provided file does not exist or is a directory or is not readable!");
            }
            this.coverageName = sourceFile.getName();
            int dotIndex = this.coverageName.indexOf(".");
            this.gzipped = this.coverageName.toLowerCase().endsWith("gz");
            this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
            this.inStream = this.gzipped ? ImageIO.createImageInputStream(new GZIPInputStream(new FileInputStream(sourceFile))) : ImageIO.createImageInputStream(sourceFile);
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            input = tempURL.openConnection().getInputStream();
            GZIPInputStream gzInStream = null;
            try {
                gzInStream = new GZIPInputStream((InputStream)input);
                this.gzipped = false;
            }
            catch (Exception e) {
                this.gzipped = false;
            }
            input = tempURL.openConnection().getInputStream();
            this.inStream = this.gzipped ? ImageIO.createImageInputStream(gzInStream) : ImageIO.createImageInputStream(tempURL.openConnection().getInputStream());
        } else if (input instanceof InputStream) {
            this.closeMe = false;
            this.inStream = ImageIO.getUseCache() ? new FileCacheImageInputStream((InputStream)input, null) : new MemoryCacheImageInputStream((InputStream)input);
            this.inStream.mark();
        } else if (input instanceof ImageInputStream) {
            this.closeMe = false;
            this.inStream = (ImageInputStream)input;
            this.inStream.mark();
        } else {
            throw new IllegalArgumentException("Unsupported input type");
        }
        if (this.inStream == null) {
            throw new DataSourceException("No input stream for the provided source");
        }
    }

    private void getResolutionInfo(ImageReader reader) throws IOException, TransformException {
        Rectangle actualDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        this.originalGridRange = new GridEnvelope2D(actualDim);
        this.highestRes = ArcGridReader.getResolution((GeneralEnvelope)this.originalEnvelope, (Rectangle2D)actualDim, (CoordinateReferenceSystem)this.crs);
    }

    public Format getFormat() {
        return new ArcGridFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope readEnvelope = null;
        Rectangle requestedDim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    readEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    requestedDim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        return this.createCoverage(readEnvelope, requestedDim, overviewPolicy);
    }

    private GridCoverage2D createCoverage(GeneralEnvelope requestedEnvelope, Rectangle requestedDim, OverviewPolicy overviewPolicy) throws IOException {
        Integer imageChoice;
        if (!this.closeMe) {
            this.inStream.reset();
            this.inStream.mark();
        }
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, requestedDim);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        ParameterBlock pbjImageRead = new ParameterBlock();
        if (this.source instanceof File) {
            if (!this.gzipped) {
                pbjImageRead.add(ImageIO.createImageInputStream(this.source));
            } else {
                pbjImageRead.add(ImageIO.createImageInputStream(new GZIPInputStream(new FileInputStream((File)this.source))));
            }
        } else if (this.source instanceof ImageInputStream || this.source instanceof InputStream) {
            pbjImageRead.add(this.inStream);
        } else if (this.source instanceof URL) {
            if (this.gzipped) {
                ImageIO.createImageInputStream(new GZIPInputStream(((URL)this.source).openConnection().getInputStream()));
            } else {
                pbjImageRead.add(ImageIO.createImageInputStream(((URL)this.source).openConnection().getInputStream()));
            }
        }
        pbjImageRead.add(imageChoice);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(null);
        pbjImageRead.add(null);
        pbjImageRead.add(readP);
        pbjImageRead.add(readerSPI.createReaderInstance());
        RenderedOp asciiCoverage = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, (RenderingHints)this.hints);
        try {
            Category values;
            Category nan;
            Unit uom = null;
            if (Double.isNaN(this.inNoData)) {
                nan = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color(0, 0, 0, 0), 0);
                values = new Category((CharSequence)"values", demColors, NumberRange.create((int)1, (int)255), NumberRange.create((int)0, (int)9000));
            } else {
                nan = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((int)0, (int)0), NumberRange.create((double)this.inNoData, (double)this.inNoData));
                values = new Category((CharSequence)"values", demColors, NumberRange.create((int)1, (int)255), NumberRange.create((double)(this.inNoData + Math.abs(this.inNoData) * 0.1), (double)(this.inNoData + Math.abs(this.inNoData) * 10.0)));
            }
            GridSampleDimension band = new GridSampleDimension((CharSequence)this.coverageName, new Category[]{nan, values}, uom).geophysics(true);
            HashMap<String, Double> properties = new HashMap<String, Double>();
            properties.put("GC_NODATA", new Double(this.inNoData));
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)asciiCoverage, (Envelope)this.originalEnvelope, new GridSampleDimension[]{band}, null, properties);
        }
        catch (NoSuchElementException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private void parseMetadata(AsciiGridsImageMetadata gridMetadata) throws MismatchedDimensionException {
        Node root = gridMetadata.getAsTree("it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata_1.0");
        Node child = root.getFirstChild();
        NamedNodeMap attributes = child.getAttributes();
        boolean grass = attributes.getNamedItem("GRASS").getNodeValue().equalsIgnoreCase("True");
        child = child.getNextSibling();
        attributes = child.getAttributes();
        int hrWidth = Integer.parseInt(attributes.getNamedItem("nColumns").getNodeValue());
        int hrHeight = Integer.parseInt(attributes.getNamedItem("nRows").getNodeValue());
        this.originalGridRange = new GridEnvelope2D(new Rectangle(0, 0, hrWidth, hrHeight));
        boolean pixelIsArea = attributes.getNamedItem("rasterSpaceType").getNodeValue().equalsIgnoreCase(AsciiGridsImageMetadata.rasterSpaceTypes[1]);
        if (!grass) {
            this.inNoData = Double.parseDouble(attributes.getNamedItem("noDataValue").getNodeValue());
        }
        child = child.getNextSibling();
        attributes = child.getAttributes();
        double cellsizeX = Double.parseDouble(attributes.getNamedItem("cellsizeX").getNodeValue());
        double cellsizeY = Double.parseDouble(attributes.getNamedItem("cellsizeY").getNodeValue());
        double xll = Double.parseDouble(attributes.getNamedItem("xll").getNodeValue());
        double yll = Double.parseDouble(attributes.getNamedItem("yll").getNodeValue());
        if (!pixelIsArea) {
            double correctionX = cellsizeX / 2.0;
            double correctionY = cellsizeY / 2.0;
            xll -= correctionX;
            yll -= correctionY;
        }
        this.originalEnvelope = new GeneralEnvelope(new double[]{xll, yll}, new double[]{xll + (double)hrWidth * cellsizeX, yll + (double)hrHeight * cellsizeY});
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCoordinateReferenceSystem() throws FileNotFoundException, IOException {
        if (this.source instanceof File || this.source instanceof URL && ((URL)this.source).getProtocol() == "file") {
            String sourceAsString = this.source instanceof File ? ((File)this.source).getAbsolutePath() : ((URL)this.source).getFile();
            int index = sourceAsString.lastIndexOf(".");
            StringBuffer prjFileName = index == -1 ? new StringBuffer(sourceAsString) : new StringBuffer(sourceAsString.substring(0, index));
            prjFileName.append(".prj");
            File prjFile = new File(prjFileName.toString());
            if (prjFile.exists()) {
                PrjFileReader projReader = null;
                try {
                    FileChannel channel = new FileInputStream(prjFile).getChannel();
                    projReader = new PrjFileReader((ReadableByteChannel)channel);
                    this.crs = projReader.getCoordinateReferenceSystem();
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                finally {
                    if (projReader != null) {
                        try {
                            projReader.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        }
        if (this.crs == null) {
            this.crs = AbstractGridFormat.getDefaultCRS();
            LOGGER.info("Unable to find crs, continuing with default WGS4 CRS");
        }
    }

    public int getGridCoverageCount() {
        return 1;
    }
}

