/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.Union;
import org.geotools.arcsde.data.view.ExpressionQualifier;
import org.geotools.arcsde.data.view.FromItemQualifier;
import org.geotools.arcsde.data.view.OrderByElementQualifier;
import org.geotools.arcsde.data.view.SelectItemQualifier;
import org.geotools.arcsde.session.ISession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectQualifier
implements SelectVisitor {
    private ISession session;
    private PlainSelect qualifiedSelect;

    public SelectQualifier(ISession session) {
        this.session = session;
    }

    public static PlainSelect qualify(ISession conn, PlainSelect select) {
        SelectQualifier q = new SelectQualifier(conn);
        select.accept((SelectVisitor)q);
        return q.qualifiedSelect;
    }

    public PlainSelect getQualifiedQuery() {
        if (this.qualifiedSelect == null) {
            throw new IllegalStateException("not created yet");
        }
        return this.qualifiedSelect;
    }

    public void visit(PlainSelect plainSelect) throws IllegalStateException {
        this.qualifiedSelect = new PlainSelect();
        List<FromItem> fromItems = this.qualifyFromItems(plainSelect.getFromItems());
        this.qualifiedSelect.setFromItems(fromItems);
        Map<String, Table> aliases = this.extractTableAliases(fromItems);
        fromItems = this.removeTableAliases(fromItems);
        List selectItems = this.qualifySelectItems(aliases, plainSelect.getSelectItems());
        this.qualifiedSelect.setSelectItems(selectItems);
        Expression where = this.qualifyWhere(aliases, plainSelect.getWhere());
        this.qualifiedSelect.setWhere(where);
        List<OrderByElement> orderByItems = this.qualifyOrderBy(aliases, plainSelect.getOrderByElements());
        this.qualifiedSelect.setOrderByElements(orderByItems);
    }

    private Map<String, Table> extractTableAliases(List<FromItem> fromItems) {
        HashMap<String, Table> aliases = new HashMap<String, Table>();
        for (FromItem fromItem : fromItems) {
            Table table;
            String alias;
            if (!(fromItem instanceof Table) || (alias = (table = (Table)fromItem).getAlias()) == null) continue;
            aliases.put(alias, table);
        }
        return aliases;
    }

    private List<FromItem> removeTableAliases(List<FromItem> fromItems) {
        ArrayList<FromItem> items = new ArrayList<FromItem>(fromItems);
        for (FromItem fromItem : items) {
            if (!(fromItem instanceof Table)) continue;
            Table table = (Table)fromItem;
            table.setAlias(null);
        }
        return items;
    }

    private Expression qualifyWhere(Map tableAliases, Expression where) {
        if (where == null) {
            return null;
        }
        Expression qualifiedWhere = ExpressionQualifier.qualify(this.session, tableAliases, where);
        return qualifiedWhere;
    }

    private List<OrderByElement> qualifyOrderBy(Map tableAliases, List orderByElements) {
        if (orderByElements == null) {
            return null;
        }
        ArrayList<OrderByElement> qualifiedOrderElems = new ArrayList<OrderByElement>();
        for (OrderByElement orderByElem : orderByElements) {
            OrderByElement qualified = OrderByElementQualifier.qualify(this.session, tableAliases, orderByElem);
            qualifiedOrderElems.add(qualified);
        }
        return qualifiedOrderElems;
    }

    private List qualifySelectItems(Map tableAlias, List selectItems) {
        if (selectItems == null) {
            return null;
        }
        ArrayList qualifiedItems = new ArrayList();
        for (SelectItem selectItem : selectItems) {
            List items = SelectItemQualifier.qualify(this.session, tableAlias, selectItem);
            qualifiedItems.addAll(items);
        }
        return qualifiedItems;
    }

    private List<FromItem> qualifyFromItems(List fromItems) {
        if (fromItems == null) {
            return null;
        }
        ArrayList<FromItem> qualifiedFromItems = new ArrayList<FromItem>();
        for (FromItem fromItem : fromItems) {
            FromItem qualifiedItem = FromItemQualifier.qualify(this.session, fromItem);
            qualifiedFromItems.add(qualifiedItem);
        }
        return qualifiedFromItems;
    }

    public void visit(Union union) {
        throw new UnsupportedOperationException();
    }
}

