/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.GraphicBuilder;
import org.opengis.style.Graphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSymbolizerBuilder<P>
implements Builder<PointSymbolizer> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    String geometry;
    GraphicBuilder<PointSymbolizerBuilder<P>> graphic = new GraphicBuilder();
    private boolean unset = false;

    public PointSymbolizerBuilder() {
        this(null);
    }

    public PointSymbolizerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public P end() {
        return this.parent;
    }

    PointSymbolizerBuilder<P> geometry(String geometry) {
        this.geometry = geometry;
        this.unset = false;
        return this;
    }

    GraphicBuilder graphic() {
        this.unset = false;
        return this.graphic;
    }

    @Override
    public PointSymbolizer build() {
        if (this.unset) {
            return null;
        }
        PointSymbolizer ps = this.sf.createPointSymbolizer(this.graphic.build(), this.geometry);
        this.reset();
        return ps;
    }

    @Override
    public PointSymbolizerBuilder<P> reset() {
        this.geometry = null;
        this.graphic.reset();
        this.unset = false;
        return this;
    }

    @Override
    public Builder<PointSymbolizer> reset(PointSymbolizer original) {
        if (original == null) {
            return this.unset();
        }
        this.geometry = original.getGeometryPropertyName();
        this.graphic.reset((Graphic)original.getGraphic());
        this.unset = false;
        return this;
    }

    @Override
    public PointSymbolizerBuilder<P> unset() {
        this.geometry = null;
        this.graphic.unset();
        this.unset = true;
        return this;
    }
}

