/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorReplacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.ColorReplacementBuilder;
import org.opengis.metadata.citation.OnLineResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalGraphicBuilder<P>
implements Builder<ExternalGraphic> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    boolean unset = true;
    private Icon inline;
    private String format;
    private OnLineResource resource;
    private Set<ColorReplacementBuilder<ExternalGraphicBuilder<P>>> replacements = new HashSet<ColorReplacementBuilder<ExternalGraphicBuilder<P>>>();

    public ExternalGraphicBuilder() {
        this(null);
    }

    public ExternalGraphicBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public String format() {
        return this.format;
    }

    public ExternalGraphicBuilder<P> format(String format) {
        this.format = format;
        return this;
    }

    public Icon inline() {
        return this.inline;
    }

    public ExternalGraphicBuilder<P> inline(Icon icon) {
        this.inline = icon;
        return this;
    }

    public Set<ColorReplacementBuilder<ExternalGraphicBuilder<P>>> replacements() {
        return this.replacements;
    }

    public ColorReplacementBuilder<ExternalGraphicBuilder<P>> replacement() {
        ColorReplacementBuilder<ExternalGraphicBuilder<P>> replacement = new ColorReplacementBuilder<ExternalGraphicBuilder<P>>(this);
        this.replacements.add(replacement);
        return replacement;
    }

    public OnLineResource resource() {
        return this.resource;
    }

    public ExternalGraphicBuilder<P> resource(OnLineResource resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public ExternalGraphic build() {
        if (this.unset) {
            return null;
        }
        HashSet<ColorReplacement> set = new HashSet<ColorReplacement>();
        for (ColorReplacementBuilder<ExternalGraphicBuilder<P>> replacement : this.replacements) {
            set.add(replacement.build());
        }
        ExternalGraphic externalGraphic = this.inline != null ? this.sf.externalGraphic(this.inline, set) : this.sf.externalGraphic(this.resource, this.format, set);
        if (this.parent == null) {
            this.reset();
        }
        return externalGraphic;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public ExternalGraphicBuilder<P> reset() {
        this.unset = false;
        return this;
    }

    @Override
    public ExternalGraphicBuilder<P> reset(AnchorPoint original) {
        if (original == null) {
            return this.reset();
        }
        this.unset = false;
        return this;
    }

    @Override
    public ExternalGraphicBuilder<P> unset() {
        this.unset = true;
        return this;
    }

    @Override
    public ExternalGraphicBuilder<P> reset(ExternalGraphic original) {
        return null;
    }
}

