/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbol;
import org.geotools.styling.builder.AnchorPointBuilder;
import org.geotools.styling.builder.DisplacementBuilder;
import org.geotools.styling.builder.ExternalGraphicBuilder;
import org.geotools.styling.builder.MarkBuilder;
import org.geotools.styling.builder.SymbolBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.AnchorPoint;
import org.opengis.style.Displacement;
import org.opengis.style.GraphicalSymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicBuilder<P>
implements Builder<org.opengis.style.Graphic> {
    boolean unset = false;
    P parent;
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    List<SymbolBuilder<GraphicBuilder<P>>> symbols = new ArrayList<SymbolBuilder<GraphicBuilder<P>>>();
    ChildExpressionBuilder<GraphicBuilder<P>> opacity = new ChildExpressionBuilder<GraphicBuilder>(this);
    ChildExpressionBuilder<GraphicBuilder<P>> size = new ChildExpressionBuilder<GraphicBuilder>(this);
    ChildExpressionBuilder<GraphicBuilder<P>> rotation = new ChildExpressionBuilder<GraphicBuilder>(this);
    private AnchorPointBuilder<GraphicBuilder<P>> anchor = new AnchorPointBuilder<GraphicBuilder>(this);
    private DisplacementBuilder<GraphicBuilder<P>> displacement = new DisplacementBuilder<GraphicBuilder>(this);

    public GraphicBuilder() {
        this.parent = null;
        this.reset();
    }

    public GraphicBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public GraphicBuilder<P> opacity(Expression opacity) {
        this.opacity.reset(opacity);
        return this;
    }

    public GraphicBuilder<P> size(Expression size) {
        this.size.reset(size);
        return this;
    }

    public GraphicBuilder<P> rotation(Expression rotation) {
        this.rotation.reset(rotation);
        return this;
    }

    public ExternalGraphicBuilder<GraphicBuilder<P>> externalGraphic() {
        SymbolBuilder<GraphicBuilder> symbolBuilder = new SymbolBuilder<GraphicBuilder>(this);
        this.symbols.add(symbolBuilder);
        return symbolBuilder.external();
    }

    public ExternalGraphicBuilder<GraphicBuilder<P>> externalGraphic(URL onlineResource, String format) {
        SymbolBuilder<GraphicBuilder> symbolBuilder = new SymbolBuilder<GraphicBuilder>(this);
        this.symbols.add(symbolBuilder);
        ExternalGraphicBuilder<GraphicBuilder<P>> external = symbolBuilder.external().format(format);
        try {
            external.resource((OnLineResource)new OnLineResourceImpl(onlineResource.toURI()));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return external;
    }

    public GraphicBuilder<P> externalGraphic(String onlineResource, String format) {
        SymbolBuilder<GraphicBuilder> symbolBuilder = new SymbolBuilder<GraphicBuilder>(this);
        this.symbols.add(symbolBuilder);
        ExternalGraphicBuilder<GraphicBuilder> external = symbolBuilder.external().format(format);
        try {
            external.resource((OnLineResource)new OnLineResourceImpl(new URI(onlineResource)));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return this;
    }

    public MarkBuilder<GraphicBuilder<P>> mark() {
        SymbolBuilder<GraphicBuilder> symbolBuilder = new SymbolBuilder<GraphicBuilder>(this);
        this.symbols.add(symbolBuilder);
        return symbolBuilder.mark();
    }

    public GraphicBuilder<P> mark(String wellKnownName) {
        SymbolBuilder<GraphicBuilder> symbolBuilder = new SymbolBuilder<GraphicBuilder>(this);
        this.symbols.add(symbolBuilder);
        symbolBuilder.mark().wellKnownName().literal(wellKnownName);
        return this;
    }

    @Override
    public Graphic build() {
        if (this.unset) {
            return null;
        }
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (SymbolBuilder<GraphicBuilder<P>> symbol : this.symbols) {
            list.add(symbol.build());
        }
        Graphic g = this.sf.graphic(list, this.opacity.build(), this.size.build(), this.rotation.build(), (AnchorPoint)this.anchor.build(), (Displacement)this.displacement.build());
        if (this.parent == null) {
            this.reset();
        }
        return g;
    }

    @Override
    public GraphicBuilder<P> unset() {
        this.unset = true;
        this.symbols.clear();
        this.opacity.unset();
        this.size.unset();
        this.rotation.unset();
        this.displacement.unset();
        this.anchor.unset();
        return this;
    }

    @Override
    public GraphicBuilder<P> reset() {
        this.unset = false;
        this.symbols.clear();
        ((ChildExpressionBuilder)this.opacity.reset()).literal(1.0);
        ((ChildExpressionBuilder)this.size.reset()).literal(16);
        ((ChildExpressionBuilder)this.rotation.reset()).literal(0);
        this.displacement.reset();
        this.anchor.reset();
        return this;
    }

    @Override
    public GraphicBuilder<P> reset(org.opengis.style.Graphic graphic) {
        if (graphic == null) {
            return this.unset();
        }
        this.unset = false;
        this.symbols.clear();
        for (GraphicalSymbol graphicalSymbol : graphic.graphicalSymbols()) {
            if (!(graphicalSymbol instanceof Symbol)) continue;
            Symbol symbol = (Symbol)graphicalSymbol;
            this.symbols.add(new SymbolBuilder<GraphicBuilder>(this).reset(symbol));
        }
        this.opacity.reset(graphic.getOpacity());
        this.size.reset(graphic.getSize());
        this.rotation.reset(graphic.getRotation());
        this.displacement.reset(graphic.getDisplacement());
        this.anchor.reset(graphic.getAnchorPoint());
        return this;
    }
}

