/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.StyleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePlacementBuilder<P>
implements Builder<LinePlacement> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    private ChildExpressionBuilder<LinePlacementBuilder<P>> offset = new ChildExpressionBuilder<LinePlacementBuilder>(this);
    private ChildExpressionBuilder<LinePlacementBuilder<P>> initialGap = new ChildExpressionBuilder<LinePlacementBuilder>(this);
    private ChildExpressionBuilder<LinePlacementBuilder<P>> gap = new ChildExpressionBuilder<LinePlacementBuilder>(this);
    boolean unset = true;
    private boolean repeated;
    private boolean generalizedLine;
    private boolean aligned;

    public LinePlacementBuilder() {
        this.parent = null;
        this.reset();
    }

    public LinePlacementBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public LinePlacement build() {
        if (this.unset) {
            return null;
        }
        LinePlacement linePlacement = this.sf.linePlacement(this.offset.build(), this.initialGap.build(), this.gap.build(), this.repeated, this.aligned, this.generalizedLine);
        return linePlacement;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public LinePlacementBuilder<P> reset() {
        this.aligned = false;
        this.generalizedLine = false;
        this.repeated = false;
        this.gap.literal(0);
        this.initialGap.literal(0);
        this.offset.literal(0);
        this.unset = false;
        return this;
    }

    @Override
    public LinePlacementBuilder<P> reset(LinePlacement placement) {
        if (placement == null) {
            return this.reset();
        }
        this.aligned = placement.isAligned();
        this.generalizedLine = placement.isGeneralizeLine();
        this.repeated = placement.isRepeated();
        this.gap.reset(placement.getGap());
        this.initialGap.reset(placement.getInitialGap());
        this.offset.reset(placement.getPerpendicularOffset());
        this.unset = false;
        return this;
    }

    @Override
    public LinePlacementBuilder<P> unset() {
        this.aligned = false;
        this.generalizedLine = false;
        this.repeated = false;
        this.gap.unset();
        this.initialGap.unset();
        this.offset.unset();
        this.unset = true;
        return this;
    }
}

