/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ExpressionBuilder;
import org.geotools.styling.Font;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.builder.FillBuilder;
import org.geotools.styling.builder.HaloBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Halo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSymbolizerBuilder<P>
implements Builder<TextSymbolizer> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    FillBuilder<TextSymbolizerBuilder<P>> fill = new FillBuilder<TextSymbolizerBuilder>(this);
    HaloBuilder<TextSymbolizerBuilder<P>> halo = new HaloBuilder<TextSymbolizerBuilder>(this).unset();
    ExpressionBuilder label = new ExpressionBuilder();
    String geometry;
    boolean unset = false;
    private LabelPlacement labelPlacement = null;

    public TextSymbolizerBuilder() {
        this(null);
    }

    public TextSymbolizerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public TextSymbolizerBuilder<P> geometry(String geometry) {
        this.geometry = geometry;
        return this;
    }

    public HaloBuilder<TextSymbolizerBuilder<P>> halo() {
        return this.halo;
    }

    @Override
    public TextSymbolizer build() {
        if (this.unset) {
            return null;
        }
        Font[] fonts = null;
        TextSymbolizer ts = this.sf.createTextSymbolizer(this.fill.build(), fonts, this.halo.build(), this.label.build(), this.labelPlacement, this.geometry);
        this.reset();
        return ts;
    }

    @Override
    public TextSymbolizerBuilder<P> unset() {
        this.reset();
        this.unset = true;
        return this;
    }

    @Override
    public TextSymbolizerBuilder<P> reset() {
        this.fill.reset();
        this.halo.unset();
        this.label.unset();
        this.geometry = null;
        this.labelPlacement = null;
        this.unset = false;
        return this;
    }

    @Override
    public TextSymbolizerBuilder<P> reset(TextSymbolizer symbolizer) {
        this.fill.reset((Fill)symbolizer.getFill());
        this.halo.reset((Halo)symbolizer.getHalo());
        this.label.reset(symbolizer.getLabel());
        this.geometry = symbolizer.getGeometryPropertyName();
        this.labelPlacement = symbolizer.getLabelPlacement();
        this.unset = false;
        return this;
    }

    public ExpressionBuilder label() {
        this.unset = false;
        return this.label;
    }

    public ExpressionBuilder label(Expression expr) {
        this.label.reset(expr);
        this.unset = false;
        return this.label;
    }
}

