/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.StrokeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineSymbolizerBuilder<P>
implements Builder<LineSymbolizer> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    StrokeBuilder<LineSymbolizerBuilder<P>> strokeBuilder = new StrokeBuilder<LineSymbolizerBuilder>(this);
    String geometry = null;
    private boolean unset = false;

    public LineSymbolizerBuilder() {
        this(null);
    }

    public LineSymbolizerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public P end() {
        return this.parent;
    }

    public LineSymbolizerBuilder<P> geometry(String geometry) {
        this.geometry = geometry;
        this.unset = false;
        return this;
    }

    public StrokeBuilder<LineSymbolizerBuilder<P>> stroke() {
        this.unset = false;
        return this.strokeBuilder;
    }

    @Override
    public LineSymbolizer build() {
        if (this.unset) {
            return null;
        }
        Stroke stroke = this.strokeBuilder == null ? this.strokeBuilder.build() : Stroke.DEFAULT;
        LineSymbolizer ls = this.sf.createLineSymbolizer(stroke, this.geometry);
        this.reset();
        return ls;
    }

    @Override
    public LineSymbolizerBuilder<P> reset() {
        this.strokeBuilder.reset();
        this.geometry = null;
        this.unset = false;
        return this;
    }

    @Override
    public LineSymbolizerBuilder<P> reset(LineSymbolizer origional) {
        return this;
    }

    @Override
    public Builder<LineSymbolizer> unset() {
        this.strokeBuilder.reset();
        this.geometry = null;
        this.unset = true;
        return this;
    }
}

