package org.tecgraf.tdk.cache;

import org.geotools.data.DataStore;

/**
 * This interface represents a {@link DataStore} with caching capabilities.
 * @author fmoura
 *
 */
public interface CachingDataStore extends DataStore 
{
	/**
	 * Clears the entire cached info for this datastore.
	 */
	void clearCache();
	
	/**
	 * Clears the cached info associated with a particular type name.  
	 * @param typename The type name of the feature source to have associated cached info cleared. 
	 */
	void clearCache(String typename);
	
	
	/**
     * Returns the original dataStore, wrapped inside the caching dataStore.
     * @return The wrapped dataStore.
     */
	DataStore getTargetDataStore();
	
//	/**
//	 * Reloads all the cached info for this datastore.
//	 * @throws IOException 
//	 */
//	void reloadCache() throws IOException;
//	
//	/**
//	 * Reloads the cached info associated with a particular type name.
//	 * @param typename The type name of the feature source to have associated cached info reloaded.
//	 * @throws IOException 
//	 */
//	void reloadCache(String typename) throws IOException;
}
