/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: SimpleCachingFeatureReader.java
 * created: Jul 13, 2009
 */
package org.tecgraf.tdk.cache;

import java.io.IOException;
import java.util.NoSuchElementException;

import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/**
 * Feature reader adapter for the cache, uses the cached values to read 
 * (don't go to the persisted data). 
 * @author fmoura, fabiomano
 * @since TDK3.0.0
 */
public class SimpleCachingFeatureReader implements CachingFeatureReader<SimpleFeatureType, SimpleFeature> 
{
	//FeatureReader<SimpleFeatureType, SimpleFeature> _wrapped;
	private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;
	private FeatureIterator<SimpleFeature> _featureIterator;
	
	public SimpleCachingFeatureReader(Query query,FeatureCacher<SimpleFeatureType, SimpleFeature> cacher)
	{
	    if (query == null)
	        throw new IllegalArgumentException("query can't be null");

        if (cacher == null)
            throw new IllegalArgumentException("cacher can't be null");
	    
        _cacher = cacher;
        FeatureCollection<SimpleFeatureType,SimpleFeature> collection = _cacher.get(query);
		_featureIterator = collection.features();
		
        // Mas e se o cache no tiver todas as features buscadas? Como isso ser buscado?
        // Soluo seria esta inteligencia estar no DataStore e nao no FeatureReader, assim
        // o feature reader no precisaria saber nada de cache, sendo apenas um wrapper de um
        // iterador de um coleo, essa sim construida a partir das features corretas.
		
	}

	@Override
	public void close() throws IOException 
	{
	    _featureIterator.close();
	}

	@Override
	public SimpleFeatureType getFeatureType() 
	{
	    return _cacher.getFeatureType(); 
	}

	@Override
	public boolean hasNext() throws IOException 
	{
		return _featureIterator.hasNext();
	}

	@Override
	public SimpleFeature next() throws IOException, IllegalArgumentException,
			NoSuchElementException 
	{
	    return _featureIterator.next();
	}

}
