/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROIShape;
import javax.media.jai.RegistryElementDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractStatisticsOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 6830028735162290160L;
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverage.processing");
    public static final ParameterDescriptor<Double> SPATIAL_SUBSAMPLING_X = new DefaultParameterDescriptor(Citations.JAI, "xPeriod", Double.class, null, null, null, null, null, true);
    public static final ParameterDescriptor<Double> SPATIAL_SUBSAMPLING_Y = new DefaultParameterDescriptor(Citations.JAI, "yPeriod", Double.class, null, null, null, null, null, true);
    public static final ParameterDescriptor<Polygon> ROI = new DefaultParameterDescriptor(Citations.JAI, "roi", Polygon.class, null, null, null, null, null, true);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public AbstractStatisticsOperationJAI(OperationDescriptor operationDescriptor) {
        super(operationDescriptor, (ParameterDescriptorGroup)new ImagingParameterDescriptors((RegistryElementDescriptor)AbstractStatisticsOperationJAI.getOperationDescriptor(operationDescriptor.getName()), REPLACED_DESCRIPTORS));
    }

    public AbstractStatisticsOperationJAI(OperationDescriptor operationDescriptor, ImagingParameterDescriptors replacements) {
        super(operationDescriptor, (ParameterDescriptorGroup)new ImagingParameterDescriptors(ImagingParameterDescriptors.properties((RegistryElementDescriptor)operationDescriptor), (RegistryElementDescriptor)operationDescriptor, "rendered", ImagingParameterDescriptors.DEFAULT_SOURCE_TYPE_MAP, REPLACED_DESCRIPTORS));
    }

    public AbstractStatisticsOperationJAI(String name) {
        super(AbstractStatisticsOperationJAI.getOperationDescriptor(name), (ParameterDescriptorGroup)new ImagingParameterDescriptors((RegistryElementDescriptor)AbstractStatisticsOperationJAI.getOperationDescriptor(name), new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    protected ParameterBlockJAI prepareParameters(ParameterValueGroup parameters) {
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockJAI block = (ParameterBlockJAI)copy.parameters;
        try {
            Polygon roiInput;
            Object o;
            LinearTransform worldToGridTransform;
            GridCoverage2D source = (GridCoverage2D)parameters.parameter(this.operation.getSourceNames()[0]).getValue();
            AffineTransform gridToWorldTransformCorrected = new AffineTransform((AffineTransform)source.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT));
            try {
                worldToGridTransform = ProjectiveTransform.create((AffineTransform)gridToWorldTransformCorrected.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                CoverageProcessingException ce = new CoverageProcessingException(e);
                throw ce;
            }
            CoordinateReferenceSystem crs = source.getCoordinateReferenceSystem2D();
            Envelope2D envelope = source.getEnvelope2D();
            double xPeriod = parameters.parameter("xPeriod").doubleValue();
            double yPeriod = parameters.parameter("yPeriod").doubleValue();
            if (!Double.isNaN(xPeriod) && !Double.isNaN(yPeriod)) {
                DirectPosition2D LLC = new DirectPosition2D(crs, envelope.x, envelope.y);
                LLC.setCoordinateReferenceSystem(crs);
                DirectPosition2D URC = new DirectPosition2D(crs, envelope.x + xPeriod, envelope.y + yPeriod);
                URC.setCoordinateReferenceSystem(crs);
                Envelope2D shrinkedEnvelope = new Envelope2D(LLC, URC);
                Rectangle2D transformedEnv = CRS.transform((MathTransform)worldToGridTransform, (org.opengis.geometry.Envelope)shrinkedEnvelope).toRectangle2D();
                block.setParameter("xPeriod", (Object)((int)transformedEnv.getWidth()));
                block.setParameter("yPeriod", (Object)((int)transformedEnv.getHeight()));
            }
            if ((o = parameters.parameter("roi").getValue()) != null && o instanceof Polygon && new ReferencedEnvelope((roiInput = (Polygon)o).getEnvelopeInternal(), source.getCoordinateReferenceSystem2D()).intersects((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope))) {
                java.awt.Polygon shapePolygon = AbstractStatisticsOperationJAI.convertPolygon(roiInput, (MathTransform)worldToGridTransform);
                block.setParameter("roi", (Object)new ROIShape((Shape)shapePolygon));
            }
            return block;
        }
        catch (Exception e) {
            CoverageProcessingException ce = new CoverageProcessingException(e);
            throw ce;
        }
    }

    private static java.awt.Polygon convertPolygon(Polygon roiInput, MathTransform worldToGridTransform) throws TransformException {
        boolean isIdentity = worldToGridTransform.isIdentity();
        java.awt.Polygon retValue = new java.awt.Polygon();
        double[] coords = new double[2];
        LineString exteriorRing = roiInput.getExteriorRing();
        CoordinateSequence exteriorRingCS = exteriorRing.getCoordinateSequence();
        int numCoords = exteriorRingCS.size();
        for (int i = 0; i < numCoords; ++i) {
            coords[0] = exteriorRingCS.getX(i);
            coords[1] = exteriorRingCS.getY(i);
            if (!isIdentity) {
                worldToGridTransform.transform(coords, 0, coords, 0, 1);
            }
            retValue.addPoint((int)(coords[0] + 0.5), (int)(coords[1] + 0.5));
        }
        return retValue;
    }

    static {
        HashSet<Object> replacedDescriptors = new HashSet<Object>();
        replacedDescriptors.add(SPATIAL_SUBSAMPLING_X);
        replacedDescriptors.add(SPATIAL_SUBSAMPLING_Y);
        replacedDescriptors.add(ROI);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }
}

