/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.coverage;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeatureUtilities {
    private FeatureUtilities() {
    }

    private static Polygon getPolygon(Rectangle2D rect) {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory gf = new GeometryFactory(pm, 0);
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        return new Polygon(ring, null, gf);
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> wrapGridCoverage(GridCoverage2D coverage) throws TransformException, SchemaException {
        Polygon bounds = FeatureUtilities.getPolygon((Rectangle2D)coverage.getEnvelope2D());
        CoordinateReferenceSystem sourceCRS = coverage.getCoordinateReferenceSystem2D();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("GridCoverage");
        ftb.add("geom", Polygon.class, sourceCRS);
        ftb.add("grid", GridCoverage.class);
        SimpleFeatureType schema = ftb.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{bounds, coverage}, null);
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Feature)feature);
        return collection;
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> wrapGridCoverageReader(AbstractGridCoverage2DReader gridCoverageReader, GeneralParameterValue[] params) throws TransformException, FactoryRegistryException, SchemaException {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory gf = new GeometryFactory(pm, 0);
        Rectangle2D rect = gridCoverageReader.getOriginalEnvelope().toRectangle2D();
        SingleCRS sourceCrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)gridCoverageReader.getCrs());
        if (sourceCrs == null) {
            throw new UnsupportedOperationException(Errors.format((int)164, (Object)gridCoverageReader.getCrs()));
        }
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        Polygon bounds = new Polygon(ring, null, gf);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("GridCoverage");
        ftb.add("geom", Polygon.class, (CoordinateReferenceSystem)sourceCrs);
        ftb.add("grid", AbstractGridCoverage2DReader.class);
        ftb.add("params", GeneralParameterValue[].class);
        SimpleFeatureType schema = ftb.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{bounds, gridCoverageReader, params}, null);
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Feature)feature);
        return collection;
    }

    public static java.awt.Polygon convertPolygon(Polygon roiInput, MathTransform worldToGridTransform) throws TransformException {
        return FeatureUtilities.convertPolygonToPointArray(roiInput, worldToGridTransform, null);
    }

    public static java.awt.Polygon convertPolygonToPointArray(Polygon roiInput, MathTransform worldToGridTransform, List<Point2D> points) throws TransformException {
        boolean isIdentity = worldToGridTransform.isIdentity();
        double[] coords = new double[2];
        LineString exteriorRing = roiInput.getExteriorRing();
        CoordinateSequence exteriorRingCS = exteriorRing.getCoordinateSequence();
        int numCoords = exteriorRingCS.size();
        java.awt.Polygon retValue = new java.awt.Polygon();
        for (int i = 0; i < numCoords; ++i) {
            coords[0] = exteriorRingCS.getX(i);
            coords[1] = exteriorRingCS.getY(i);
            if (!isIdentity) {
                worldToGridTransform.transform(coords, 0, coords, 0, 1);
            }
            int x = (int)(coords[0] + 0.5);
            int y = (int)(coords[1] + 0.5);
            if (points != null) {
                points.add(new Point2D.Double(coords[0], coords[1]));
            }
            retValue.addPoint(x, y);
        }
        return retValue;
    }
}

