/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.util.List;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import org.geotools.resources.UnmodifiableArrayList;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Projection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicMetadataFormat
extends IIOMetadataFormatImpl {
    public static final String FORMAT_NAME = "geotools_coverage_1.0";
    private static final int MAXIMUM_DIMENSIONS = 4;
    private static final int MAXIMUM_BANDS = Short.MAX_VALUE;
    private static final int MAXIMUM_PARAMETERS = 10;
    public static final String GEOGRAPHIC = "geographic";
    public static final String GEOGRAPHIC_3D = "geographic3D";
    public static final String PROJECTED = "projected";
    public static final String PROJECTED_3D = "projected3D";
    public static final String ELLIPSOIDAL = "ellipsoidal";
    public static final String CARTESIAN = "cartesian";
    public static final String GEOPHYSICS = "geophysics";
    public static final String PACKED = "packed";
    public static final String ENGINEERING = "engineering";
    public static final String GEODETIC = "geodetic";
    public static final String IMAGE = "image";
    public static final String TEMPORAL = "temporal";
    public static final String VERTICAL = "vertical";
    static final List<String> CRS_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"geographic", "projected"});
    static final List<String> CS_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"ellipsoidal", "cartesian"});
    static final List<String> DATUM_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"engineering", "geodetic", "image", "temporal", "vertical"});
    static final List<String> DIRECTIONS = UnmodifiableArrayList.wrap((Object[])new String[]{"north", "east", "south", "west", "up", "down"});
    static final List<String> PIXEL_ORIENTATIONS = UnmodifiableArrayList.wrap((Object[])new String[]{"center", "lower left", "lower right", "upper right", "upper left"});
    static final List<String> SAMPLE_TYPES = UnmodifiableArrayList.wrap((Object[])new String[]{"geophysics", "packed"});
    private static GeographicMetadataFormat DEFAULT;

    private GeographicMetadataFormat() {
        this(FORMAT_NAME, 4, Short.MAX_VALUE);
    }

    protected GeographicMetadataFormat(String rootName, int maximumDimensions, int maximumBands) {
        super(rootName, 2);
        this.addElement("boundedBy", rootName, 1);
        this.addElement("lowerCorner", "boundedBy", 0);
        this.addElement("upperCorner", "boundedBy", 0);
        this.addObjectValue("lowerCorner", Double.TYPE, 1, 4);
        this.addObjectValue("upperCorner", Double.TYPE, 1, 4);
        this.addElement("rectifiedGridDomain", rootName, 2);
        this.addAttribute("rectifiedGridDomain", "dimension", 2, true, null);
        this.addAttribute("rectifiedGridDomain", "srsName", 0);
        this.addElement("crs", "rectifiedGridDomain", 2);
        this.addAttribute("crs", "name", 0);
        this.addAttribute("crs", "type", 0, false, null, CRS_TYPES);
        this.addElement("datum", "crs", 2);
        this.addAttribute("datum", "name", 0);
        this.addAttribute("datum", "type", 0, false, null, DATUM_TYPES);
        this.addElement("ellipsoid", "datum", 1);
        this.addAttribute("ellipsoid", "name", 0);
        this.addAttribute("ellipsoid", "unit", 0);
        this.addElement("primeMeridian", "datum", 0);
        this.addAttribute("primeMeridian", "name", 0);
        this.addAttribute("primeMeridian", "greenwichLongitude", 4);
        this.addElement("semiMajorAxis", "ellipsoid", 0);
        this.addObjectValue("semiMajorAxis", Double.class);
        this.addElement("secondDefiningParameter", "ellipsoid", 3);
        this.addElement("semiMinorAxis", "secondDefiningParameter", 0);
        this.addObjectValue("semiMinorAxis", Double.class);
        this.addElement("inverseFlattening", "secondDefiningParameter", 0);
        this.addObjectValue("inverseFlattening", Double.class);
        this.addElement("cs", "crs", 2, maximumDimensions);
        this.addAttribute("cs", "name", 0);
        this.addAttribute("cs", "type", 0, false, null, CS_TYPES);
        this.addElement("axis", "cs", 0);
        this.addAttribute("axis", "name", 0);
        this.addAttribute("axis", "direction", 0, true, null, DIRECTIONS);
        this.addAttribute("axis", "units", 0);
        this.addAttribute("axis", "origin", 0);
        this.addElement("projection", "crs", 0, 10);
        this.addAttribute("projection", "name", 0);
        this.addElement("parameter", "projection", 0);
        this.addAttribute("parameter", "name", 0);
        this.addAttribute("parameter", "value", 4);
        this.addElement("limits", "rectifiedGridDomain", 1);
        this.addElement("low", "limits", 0);
        this.addElement("high", "limits", 0);
        this.addObjectValue("low", Integer.class);
        this.addObjectValue("high", Integer.class);
        this.addElement("origin", "rectifiedGridDomain", 1);
        this.addElement("coordinates", "origin", 0);
        this.addElement("cells", "rectifiedGridDomain", 1, 4);
        this.addElement("offsetVector", "cells", 0);
        this.addElement("localizationGrid", "rectifiedGridDomain", 1, 4);
        this.addElement("ordinates", "localizationGrid", 0);
        this.addElement("pixelOrientation", "rectifiedGridDomain", 0);
        this.addObjectValue("pixelOrientation", String.class, 1, PIXEL_ORIENTATIONS.size());
        this.addElement("rangeSet", "rectifiedGridDomain", 2);
        this.addElement("rangeParameters", "rangeSet", 0);
        this.addElement("fileName", "rangeSet", 0);
        this.addElement("fileStructure", "rangeSet", 0);
        this.addElement("fileDate", "rangeSet", 0);
        this.addElement("fileFormat", "rangeSet", 0);
        this.addElement("spatialResolution", "rangeSet", 0);
        this.addAttribute("spatialResolution", "uom", 0);
        this.addElement("spectrum", "rangeSet", 0);
        this.addElement("bandRange", "rangeSet", 0, Short.MAX_VALUE);
        this.addAttribute("bandRange", "uom", 0);
        this.addElement("bands", "rangeSet", 0, Short.MAX_VALUE);
        this.addAttribute("bands", "type", 0, false, null, SAMPLE_TYPES);
        this.addElement("band", "bands", 0);
        this.addElement("mimeType", "rangeSet", 0);
        this.addElement("compression", "rangeSet", 0);
        this.addAttribute("band", "name", 0);
        this.addAttribute("band", "scale", 4);
        this.addAttribute("band", "offset", 4);
        this.addAttribute("band", "minValue", 4);
        this.addAttribute("band", "maxValue", 4);
        this.addAttribute("band", "fillValues", 4, false, 0, Short.MAX_VALUE);
        this.addObjectValue("crs", CoordinateReferenceSystem.class);
        this.addObjectValue("datum", Datum.class);
        this.addObjectValue("ellipsoid", Ellipsoid.class);
        this.addObjectValue("cs", CoordinateSystem.class);
        this.addObjectValue("axis", CoordinateSystemAxis.class);
        this.addObjectValue("projection", Projection.class);
        this.addObjectValue("parameter", ParameterValue.class);
        this.addObjectValue("boundedBy", Envelope.class);
        this.addObjectValue("primeMeridian", PrimeMeridian.class);
    }

    private void addAttribute(String elementName, String attrName, int dataType) {
        this.addAttribute(elementName, attrName, dataType, false, null);
    }

    private void addObjectValue(String elementName, Class<?> classType) {
        this.addObjectValue(elementName, classType, false, null);
    }

    @Override
    public boolean canNodeAppear(String elementName, ImageTypeSpecifier imageType) {
        return true;
    }

    public static synchronized GeographicMetadataFormat getInstance() {
        if (DEFAULT == null) {
            DEFAULT = new GeographicMetadataFormat();
        }
        return DEFAULT;
    }
}

