/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.io.Serializable;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.util.Utilities;

public class Identification
implements CharSequence,
Serializable {
    private static final long serialVersionUID = 7439545624472885445L;
    public final String name;
    public final String type;

    public Identification(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Identification(MetadataAccessor accessor) {
        this.name = accessor.getAttributeAsString("name");
        this.type = accessor.getAttributeAsString("type");
    }

    public int length() {
        return this.name != null ? this.name.length() : 0;
    }

    public char charAt(int index) {
        return this.name.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new Identification(this.name.substring(start, end), this.type);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int code = 1023711429;
        if (this.name != null) {
            code ^= this.name.hashCode();
        }
        if (this.type != null) {
            code += this.type.hashCode() * 37;
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Identification that = (Identification)object;
            return Utilities.equals((Object)this.name, (Object)that.name) && Utilities.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

