/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.tree.TreeNode;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.resources.Classes;
import org.geotools.resources.OptionalDependencies;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.UnsupportedImplementationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAccessor {
    private static final char SEPARATOR = '/';
    final GeographicMetadata metadata;
    private final Node parent;
    private final String childPath;
    private final List<Node> childs;
    private transient Element current;
    private transient boolean warningsEnabled = true;

    protected MetadataAccessor(MetadataAccessor clone) {
        this.metadata = clone.metadata;
        this.parent = clone.parent;
        this.childPath = clone.childPath;
        this.childs = clone.childs;
    }

    protected MetadataAccessor(GeographicMetadata metadata, String parentPath, String childPath) {
        this.metadata = metadata;
        Node root = metadata.getRootNode();
        ArrayList<Node> childs = new ArrayList<Node>(4);
        if (parentPath != null) {
            MetadataAccessor.listChilds(root, parentPath, 0, childs, true);
            int count = childs.size();
            switch (count) {
                default: {
                    this.warning("<init>", 124, new Object[]{parentPath, count});
                }
                case 1: {
                    this.parent = (Node)childs.get(0);
                    childs.clear();
                    break;
                }
                case 0: {
                    this.parent = MetadataAccessor.appendChild(root, parentPath);
                    break;
                }
            }
        } else {
            this.parent = root;
        }
        this.childPath = childPath;
        if (childPath != null) {
            String path = parentPath != null ? parentPath + '/' + childPath : childPath;
            MetadataAccessor.listChilds(root, path, 0, childs, false);
            this.childs = childs;
        } else {
            this.childs = Collections.emptyList();
        }
        if (this.parent instanceof Element) {
            this.current = (Element)this.parent;
        }
    }

    private static void listChilds(Node parent, String path, int base, List<Node> childs, boolean includeNodes) {
        int upper = path.indexOf(47, base);
        String name = (upper >= 0 ? path.substring(base, upper) : path.substring(base)).trim();
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node candidate = list.item(i);
            if (!name.equals(candidate.getNodeName())) continue;
            if (upper >= 0) {
                MetadataAccessor.listChilds(candidate, path, upper + 1, childs, includeNodes);
                continue;
            }
            if (!includeNodes && !(candidate instanceof Element)) continue;
            childs.add(candidate);
        }
    }

    private static Node appendChild(Node parent, String path) {
        int upper;
        int lower = 0;
        while ((upper = path.indexOf(47, lower)) >= 0) {
            block2: {
                int length;
                String name = path.substring(lower, upper).trim();
                NodeList list = parent.getChildNodes();
                int i = length = list.getLength();
                while (--i >= 0) {
                    Node candidate = list.item(i);
                    if (!name.equals(candidate.getNodeName())) continue;
                    parent = candidate;
                    break block2;
                }
                parent = parent.appendChild(new IIOMetadataNode(name.intern()));
            }
            lower = upper + 1;
        }
        String name = path.substring(lower).trim().intern();
        return parent.appendChild(new IIOMetadataNode(name));
    }

    protected int childCount() {
        return this.childs.size();
    }

    protected int appendChild() {
        int size = this.childs.size();
        Node child = MetadataAccessor.appendChild(this.parent, this.childPath);
        if (child instanceof Element) {
            this.childs.add((Element)child);
            return size;
        }
        throw new UnsupportedImplementationException(child.getClass());
    }

    protected void selectChild(int index) throws IndexOutOfBoundsException {
        this.current = (Element)this.childs.get(index);
    }

    protected void selectParent() throws NoSuchElementException {
        if (!(this.parent instanceof Element)) {
            throw new NoSuchElementException();
        }
        this.current = (Element)this.parent;
    }

    private Element currentElement() throws IllegalStateException {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return this.current;
    }

    protected Object getUserObject() {
        Object candidate;
        Element element = this.currentElement();
        if (element instanceof IIOMetadataNode && (candidate = ((IIOMetadataNode)element).getUserObject()) != null) {
            return candidate;
        }
        return element.getNodeValue();
    }

    protected <T> T getUserObject(Class<? extends T> type) throws ClassCastException {
        type = Classes.primitiveToWrapper(type).asSubclass(type);
        Object value = this.getUserObject();
        if (value instanceof CharSequence) {
            if (Number.class.isAssignableFrom(type)) {
                value = Classes.valueOf(type, (String)value.toString());
            } else {
                Class component = Classes.primitiveToWrapper(type.getComponentType());
                if (Double.class.equals((Object)component)) {
                    value = this.parseSequence(value.toString(), false, false);
                } else if (Integer.class.equals((Object)component)) {
                    value = this.parseSequence(value.toString(), false, true);
                }
            }
        }
        return type.cast(value);
    }

    protected void setUserObject(Object value) throws UnsupportedImplementationException {
        Element element = this.currentElement();
        String asText = null;
        if (value != null) {
            Class<?> type = value.getClass();
            if (MetadataAccessor.isFormattable(type)) {
                asText = value.toString();
            } else if (MetadataAccessor.isFormattable(type.getComponentType())) {
                asText = MetadataAccessor.formatSequence(value);
            }
        }
        if (element instanceof IIOMetadataNode) {
            ((IIOMetadataNode)element).setUserObject(value);
        } else if (value != null && asText == null) {
            throw new UnsupportedImplementationException(Errors.format((int)45, (Object)Classes.getClass((Object)element), IIOMetadataNode.class));
        }
        element.setNodeValue(asText);
    }

    private static boolean isFormattable(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(Classes.primitiveToWrapper(type));
    }

    protected String getAttributeAsString(String attribute) {
        String candidate = this.currentElement().getAttribute(attribute);
        if (candidate != null && (candidate = candidate.trim()).length() == 0) {
            candidate = null;
        }
        return candidate;
    }

    protected void setAttributeAsString(String attribute, String value) {
        Element element = this.currentElement();
        if (value == null || (value = value.trim()).length() == 0) {
            if (element.hasAttribute(attribute)) {
                element.removeAttribute(attribute);
            }
        } else {
            element.setAttribute(attribute, value);
        }
    }

    final void setAttributeAsEnum(String attribute, String value, Collection enums) {
        if (value != null) {
            value = value.replace('_', ' ').trim();
            for (String e : enums) {
                if (!value.equalsIgnoreCase(e)) continue;
                value = e;
                break;
            }
        }
        this.setAttributeAsString(attribute, value);
    }

    protected Integer getAttributeAsInteger(String attribute) {
        String value = this.getAttributeAsString(attribute);
        if (value != null) {
            value = MetadataAccessor.trimFractionalPart(value);
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.warning("getAttributeAsInteger", 138, value);
            }
        }
        return null;
    }

    protected void setAttributeAsInteger(String attribute, int value) {
        this.setAttributeAsString(attribute, Integer.toString(value));
    }

    protected int[] getAttributeAsIntegers(String attribute, boolean unique) {
        return (int[])this.parseSequence(this.getAttributeAsString(attribute), unique, true);
    }

    protected void setAttributeAsIntegers(String attribute, int[] values) {
        this.setAttributeAsString(attribute, MetadataAccessor.formatSequence(values));
    }

    protected Double getAttributeAsDouble(String attribute) {
        String value = this.getAttributeAsString(attribute);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.warning("getAttributeAsDouble", 138, value);
            }
        }
        return null;
    }

    protected void setAttributeAsDouble(String attribute, double value) {
        String text = null;
        if (!Double.isNaN(value) && !Double.isInfinite(value)) {
            text = Double.toString(value);
        }
        this.setAttributeAsString(attribute, text);
    }

    protected double[] getAttributeAsDoubles(String attribute, boolean unique) {
        return (double[])this.parseSequence(this.getAttributeAsString(attribute), unique, false);
    }

    protected void setAttributeAsDoubles(String attribute, double[] values) {
        this.setAttributeAsString(attribute, MetadataAccessor.formatSequence(values));
    }

    private Object parseSequence(String sequence, boolean unique, boolean integers) {
        if (sequence == null) {
            return null;
        }
        AbstractCollection numbers = unique ? new LinkedHashSet() : new ArrayList();
        StringTokenizer tokens = new StringTokenizer(sequence);
        while (tokens.hasMoreTokens()) {
            Number number;
            String token = tokens.nextToken();
            try {
                number = integers ? (Number)Integer.valueOf(token) : (Number)Double.valueOf(token);
            }
            catch (NumberFormatException e) {
                this.warning(integers ? "getAttributeAsIntegers" : "getAttributeAsDoubles", 138, token);
                continue;
            }
            numbers.add(number);
        }
        int count = 0;
        Object[] values = integers ? new int[numbers.size()] : (Object[])new double[numbers.size()];
        Iterator it = numbers.iterator();
        while (it.hasNext()) {
            Array.set(values, count++, it.next());
        }
        assert (Array.getLength(values) == count);
        return values;
    }

    private static String formatSequence(Object values) {
        String text = null;
        if (values != null) {
            StringBuilder buffer = new StringBuilder();
            int length = Array.getLength(values);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(Array.get(values, i));
            }
            text = buffer.toString();
        }
        return text;
    }

    protected Date getAttributeAsDate(String attribute) {
        String value = this.getAttributeAsString(attribute);
        if (value != null) {
            value = MetadataAccessor.trimFractionalPart(value);
            return (Date)this.metadata.dateFormat().parse(value);
        }
        return null;
    }

    protected void setAttributeAsDate(String attribute, Date value) {
        String text = null;
        if (value != null) {
            text = this.metadata.dateFormat().format((Object)value);
        }
        this.setAttributeAsString(attribute, text);
    }

    public static String trimFractionalPart(String value) {
        value = value.trim();
        int i = value.length();
        block4: while (--i >= 0) {
            switch (value.charAt(i)) {
                case '0': {
                    continue block4;
                }
                case '.': {
                    return value.substring(0, i);
                }
            }
            return value;
        }
        return value;
    }

    final void warning(String method, int key, Object value) {
        if (this.warningsEnabled) {
            LogRecord record = Errors.getResources((Locale)this.metadata.getLocale()).getLogRecord(Level.WARNING, key, value);
            record.setSourceClassName(MetadataAccessor.class.getName());
            record.setSourceMethodName(method);
            this.warningOccurred(record);
        }
    }

    protected void warningOccurred(LogRecord record) {
        if (this.warningsEnabled) {
            this.metadata.warningOccurred(record);
        }
    }

    protected boolean setWarningsEnabled(boolean enabled) {
        boolean old = this.warningsEnabled;
        this.warningsEnabled = enabled;
        return old;
    }

    public String toString() {
        return OptionalDependencies.toString((TreeNode)OptionalDependencies.xmlToSwing((Node)this.parent));
    }
}

