/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.cli2.Option;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MosaicIndexBuilder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private static final Logger LOGGER = Logging.getLogger((String)"it.geosolutions.utils.imagemosaic");
    private static final String VERSION = "0.3";
    private static final String NAME = "MosaicIndexBuilder";
    private final Option locationOpt = this.optionBuilder.withShortName("s").withLongName("source_directory").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).create()).withDescription("path where files are located").withRequired(true).create();
    private final Option nameOpt;
    private final Option relativePathOpt;
    private final Option wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.argumentBuilder.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
    private String locationPath;
    private int numberOfLevels;
    private double[][] resolutionLevels;
    private int numFiles;
    private String wildcardString = "*.*";
    private String indexName = "index";
    private boolean mustConvertToRGB = false;
    private ColorModel actualCM = null;
    private ColorModel defaultCM = null;
    private SampleModel defaultSM = null;
    private SampleModel actualSM = null;
    private GeneralEnvelope globEnvelope = null;
    private GeneralEnvelope envelope = null;
    private byte[][] defaultPalette = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private CoordinateReferenceSystem actualCRS = null;
    private boolean absolute = false;

    private void recurse(List<File> allFiles, String locationPath) {
        int i;
        File dir = new File(locationPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(this.wildcardString);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        File[] dirs = dir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        for (i = 0; i < files.length; ++i) {
            allFiles.add(files[i]);
        }
        for (i = 0; i < dirs.length; ++i) {
            this.recurse(allFiles, locationPath + '/' + dirs[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block60: {
            block59: {
                handler = null;
                try {
                    try {
                        append = true;
                        handler = new FileHandler(new StringBuffer(this.locationPath).append("/error.txt").toString(), append);
                        handler.setLevel(Level.SEVERE);
                        MosaicIndexBuilder.LOGGER.addHandler(handler);
                        skipFiles = new HashSet<String>(Arrays.asList(new String[]{this.indexName + ".shp", this.indexName + ".dbf", this.indexName + ".shx", this.indexName + ".prj", "error.txt", "error.txt.lck", this.indexName + ".properties"}));
                        index = null;
                        t = new DefaultTransaction();
                        precMod = new PrecisionModel(PrecisionModel.FLOATING);
                        geomFactory = new GeometryFactory(precMod);
                        try {
                            index = new ShapefileDataStore(new File(this.locationPath + File.separator + this.indexName + ".shp").toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            if (MosaicIndexBuilder.LOGGER.isLoggable(Level.SEVERE)) {
                                MosaicIndexBuilder.LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                            }
                            this.fireException(ex);
                            var27_12 = null;
                            try {
                                if (handler == null) return;
                                handler.close();
                                return;
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            return;
                        }
                        files = new ArrayList<File>();
                        this.recurse(files, this.locationPath);
                        this.numFiles = files.size();
                        validFileName = null;
                        filesIt = files.iterator();
                        fw = null;
                        doneSomething = false;
                        for (i = 0; i < this.numFiles; ++i) {
                            fileBeingProcessed = (File)filesIt.next();
                            if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                                message = new StringBuffer("Skipped file ").append(files.get(i)).append(" snce it seems invalid.");
                                if (MosaicIndexBuilder.LOGGER.isLoggable(Level.INFO)) {
                                    MosaicIndexBuilder.LOGGER.info(message.toString());
                                }
                                this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                                continue;
                            }
                            if (this.getStopThread()) {
                                message = new StringBuffer("Stopping requested at file  ").append(i).append(" of ").append(this.numFiles).append(" files");
                                if (MosaicIndexBuilder.LOGGER.isLoggable(Level.FINE)) {
                                    MosaicIndexBuilder.LOGGER.fine(message.toString());
                                }
                                this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
                                var27_13 = null;
                                break block59;
                            }
                            try {
                                validFileName = fileBeingProcessed.getCanonicalPath();
                            }
                            catch (IOException e1) {
                                this.fireException(e1);
                                var27_14 = null;
                                ** try [egrp 12[TRYBLOCK] [34 : 2093->2104)] { 
lbl60:
                                // 1 sources

                                if (handler == null) return;
                                handler.close();
                                return;
lbl63:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                                return;
                            }
                            validFileName = validFileName.replace('\\', '/');
                            validFileName = validFileName.substring(this.locationPath.length() + 1, fileBeingProcessed.getAbsolutePath().length());
                            if (skipFiles.contains(validFileName)) continue;
                            message = new StringBuffer("Now indexing file ").append(validFileName);
                            if (MosaicIndexBuilder.LOGGER.isLoggable(Level.FINE)) {
                                MosaicIndexBuilder.LOGGER.fine(message.toString());
                            }
                            this.fireEvent(message.toString(), (double)i * 100.0 / (double)this.numFiles);
                            try {
                                block62: {
                                    block63: {
                                        block61: {
                                            inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                            if (inStream == null) {
                                                if (!MosaicIndexBuilder.LOGGER.isLoggable(Level.SEVERE)) continue;
                                                MosaicIndexBuilder.LOGGER.severe(fileBeingProcessed + " has been skipped since we could not get a stream for it");
                                                continue;
                                            }
                                            inStream.mark();
                                            it = ImageIO.getImageReaders(inStream);
                                            r = null;
                                            if (!it.hasNext()) break block61;
                                            r = it.next();
                                            r.setInput(inStream);
                                            if (!MosaicIndexBuilder.LOGGER.isLoggable(Level.FINE)) break block62;
                                            break block63;
                                        }
                                        try {
                                            inStream.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        message = new StringBuffer("Skipped file ").append(files.get(i)).append(":No ImageIO readeres avalaible.");
                                        if (MosaicIndexBuilder.LOGGER.isLoggable(Level.INFO)) {
                                            MosaicIndexBuilder.LOGGER.info(message.toString());
                                        }
                                        this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                                        continue;
                                    }
                                    MosaicIndexBuilder.LOGGER.fine(new StringBuffer("Getting a reader").toString());
                                }
                                if ((format = GridFormatFinder.findFormat(files.get(i))) == null || !format.accepts(files.get(i))) {
                                    try {
                                        inStream.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        r.dispose();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    message = new StringBuffer("Skipped file ").append(files.get(i)).append(": File format is not supported.");
                                    if (MosaicIndexBuilder.LOGGER.isLoggable(Level.INFO)) {
                                        MosaicIndexBuilder.LOGGER.info(message.toString());
                                    }
                                    this.fireEvent(message.toString(), (double)i * 99.0 / (double)this.numFiles);
                                    continue;
                                }
                                reader = format.getReader(files.get(i));
                                this.envelope = reader.getOriginalEnvelope();
                                this.actualCRS = reader.getCrs();
                                its = r.getImageTypes(0).next();
                                skipFeature = false;
                                if (this.globEnvelope == null) {
                                    this.defaultCM = its.getColorModel();
                                    if (this.defaultCM instanceof IndexColorModel) {
                                        icm = (IndexColorModel)this.defaultCM;
                                        numBands = this.defaultCM.getNumColorComponents();
                                        this.defaultPalette = new byte[3][icm.getMapSize()];
                                        icm.getReds(this.defaultPalette[0]);
                                        icm.getGreens(this.defaultPalette[0]);
                                        icm.getBlues(this.defaultPalette[0]);
                                        if (numBands == 4) {
                                            icm.getAlphas(this.defaultPalette[0]);
                                        }
                                    }
                                    this.defaultSM = its.getSampleModel();
                                    this.defaultCRS = this.actualCRS;
                                    this.globEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)this.envelope);
                                    r.reset();
                                    try {
                                        inStream.reset();
                                    }
                                    catch (IOException e) {
                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                    }
                                    if (inStream == null) {
                                        if (!MosaicIndexBuilder.LOGGER.isLoggable(Level.WARNING)) continue;
                                        MosaicIndexBuilder.LOGGER.warning("Skipping file " + fileBeingProcessed.toString());
                                        continue;
                                    }
                                    r.setInput(inStream);
                                    this.numberOfLevels = r.getNumImages(true);
                                    this.resolutionLevels = new double[2][this.numberOfLevels];
                                    res = this.getResolution(this.envelope, new Rectangle(r.getWidth(0), r.getHeight(0)), this.defaultCRS);
                                    this.resolutionLevels[0][0] = res[0];
                                    this.resolutionLevels[1][0] = res[1];
                                    if (this.numberOfLevels > 1) {
                                        for (k = 0; k < this.numberOfLevels; ++k) {
                                            res = this.getResolution(this.envelope, new Rectangle(r.getWidth(k), r.getHeight(k)), this.defaultCRS);
                                            this.resolutionLevels[0][k] = res[0];
                                            this.resolutionLevels[1][k] = res[1];
                                        }
                                    }
                                    featureBuilder = new SimpleFeatureTypeBuilder();
                                    featureBuilder.setName("Flag");
                                    featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
                                    featureBuilder.add("location", String.class);
                                    featureBuilder.add("the_geom", Polygon.class, this.actualCRS);
                                    featureBuilder.setDefaultGeometry("the_geom");
                                    simpleFeatureType = featureBuilder.buildFeatureType();
                                    index.createSchema(simpleFeatureType);
                                    fw = index.getFeatureWriter((Transaction)t);
                                } else {
                                    this.globEnvelope.add((org.opengis.geometry.Envelope)this.envelope);
                                    this.actualCM = its.getColorModel();
                                    this.actualSM = its.getSampleModel();
                                    v0 = i > 0 ? !CRS.equalsIgnoreMetadata((Object)this.defaultCRS, (Object)this.actualCRS) : (skipFeature = false);
                                    if (skipFeature) {
                                        MosaicIndexBuilder.LOGGER.warning(new StringBuffer("Skipping image ").append(files.get(i)).append(" because CRSs do not match.").toString());
                                    }
                                    if (skipFeature = this.checkColorModels(this.defaultCM, this.defaultPalette, this.actualCM)) {
                                        MosaicIndexBuilder.LOGGER.warning(new StringBuffer("Skipping image ").append(files.get(i)).append(" because color models do not match.").toString());
                                    }
                                }
                                if (!skipFeature) {
                                    feature = (SimpleFeature)fw.next();
                                    feature.setAttribute(1, (Object)geomFactory.toGeometry((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)this.envelope)));
                                    feature.setAttribute(0, (Object)(this.absolute != false ? this.locationPath + File.separatorChar + validFileName : validFileName));
                                    fw.write();
                                    message = new StringBuffer("Done with file ").append(files.get(i));
                                    if (MosaicIndexBuilder.LOGGER.isLoggable(Level.FINE)) {
                                        MosaicIndexBuilder.LOGGER.fine(message.toString());
                                    }
                                    message.append('\n');
                                    this.fireEvent(message.toString(), (double)(i + 1) * 99.0 / (double)this.numFiles);
                                    doneSomething = true;
                                } else {
                                    skipFeature = false;
                                }
                                try {
                                    inStream.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    r.dispose();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                reader.dispose();
                                continue;
                            }
                            catch (IOException e) {
                                this.fireException(e);
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                this.fireException(e);
                                break;
                            }
                        }
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                            t.commit();
                            t.close();
                            index.dispose();
                        }
                        catch (IOException e) {
                            MosaicIndexBuilder.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        this.createPropertiesFiles(this.globEnvelope, doneSomething);
                        break block60;
                    }
                    catch (SecurityException el) {
                        this.fireException(el);
                        var27_16 = null;
                        ** try [egrp 12[TRYBLOCK] [34 : 2093->2104)] { 
lbl224:
                        // 1 sources

                        if (handler == null) return;
                        handler.close();
                        return;
lbl227:
                        // 1 sources

                        catch (Throwable e) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (IOException el) {
                        this.fireException(el);
                        var27_17 = null;
                        ** try [egrp 12[TRYBLOCK] [34 : 2093->2104)] { 
lbl235:
                        // 1 sources

                        if (handler == null) return;
                        handler.close();
                        return;
lbl238:
                        // 1 sources

                        catch (Throwable e) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable var26_54) {
                    var27_18 = null;
                    ** try [egrp 12[TRYBLOCK] [34 : 2093->2104)] { 
lbl245:
                    // 1 sources

                    if (handler == null) throw var26_54;
                    handler.close();
                    throw var26_54;
lbl248:
                    // 1 sources

                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw var26_54;
                }
            }
            ** try [egrp 12[TRYBLOCK] [34 : 2093->2104)] { 
lbl253:
            // 1 sources

            if (handler == null) return;
            handler.close();
            return;
lbl256:
            // 1 sources

            catch (Throwable e) {
                // empty catch block
            }
            return;
        }
        var27_15 = null;
        try {}
        catch (Throwable e) {}
        if (handler == null) return;
        handler.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createPropertiesFiles(GeneralEnvelope globEnvelope, boolean doneSomething) {
        if (this.numFiles > 0 && doneSomething) {
            StringBuffer message;
            block23: {
                message = new StringBuffer("Creating final properties file ");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), 99.9);
                Properties properties = new Properties();
                properties.setProperty("AbsolutePath", Boolean.toString(this.absolute));
                properties.setProperty("NumFiles", Integer.toString(this.numFiles));
                properties.setProperty("Envelope2D", new StringBuffer(Double.toString(globEnvelope.getMinimum(0))).append(",").append(Double.toString(globEnvelope.getMinimum(1))).append(" ").append(Double.toString(globEnvelope.getMaximum(0))).append(",").append(Double.toString(globEnvelope.getMaximum(1))).toString());
                properties.setProperty("LevelsNum", Integer.toString(this.numberOfLevels));
                StringBuffer levels = new StringBuffer();
                for (int k = 0; k < this.numberOfLevels; ++k) {
                    levels.append(Double.toString(this.resolutionLevels[0][k])).append(",").append(Double.toString(this.resolutionLevels[1][k]));
                    if (k >= this.numberOfLevels - 1) continue;
                    levels.append(" ");
                }
                properties.setProperty("Levels", levels.toString());
                properties.setProperty("Name", this.indexName);
                properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
                OutputStream outStream = null;
                outStream = new BufferedOutputStream(new FileOutputStream(this.locationPath + "/" + this.indexName + ".properties"));
                properties.store(outStream, "");
                Object var9_9 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                    break block23;
                }
                catch (Throwable e2) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                    }
                    break block23;
                }
                {
                    catch (FileNotFoundException e) {
                        this.fireEvent(e.getLocalizedMessage(), 0.0);
                        Object var9_10 = null;
                        try {
                            if (outStream != null) {
                                outStream.close();
                            }
                            break block23;
                        }
                        catch (Throwable e2) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                            }
                            break block23;
                        }
                    }
                    catch (IOException e) {
                        this.fireEvent(e.getLocalizedMessage(), 0.0);
                        Object var9_11 = null;
                        try {
                            if (outStream != null) {
                                outStream.close();
                            }
                            break block23;
                        }
                        catch (Throwable e2) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block24: {
                        Object var9_12 = null;
                        try {
                            if (outStream != null) {
                                outStream.close();
                            }
                        }
                        catch (Throwable e2) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block24;
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                    }
                    throw throwable;
                }
            }
            message = new StringBuffer("Done!!!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        } else {
            StringBuffer message = new StringBuffer("No file to process!!!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.fireEvent(message.toString(), 100.0);
        }
    }

    private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
        if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
            ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
            ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
            return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !defCCM.getColorSpace().equals(actualCCM.getColorSpace()) || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
        }
        if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
            IndexColorModel defICM = (IndexColorModel)defaultCM;
            IndexColorModel actualICM = (IndexColorModel)actualCM;
            if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                return true;
            }
            if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                this.mustConvertToRGB = true;
                return false;
            }
            int numBands = actualICM.getNumColorComponents();
            byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
            actualICM.getReds(actualPalette[0]);
            actualICM.getGreens(actualPalette[0]);
            actualICM.getBlues(actualPalette[0]);
            if (numBands == 4) {
                actualICM.getAlphas(defaultPalette[0]);
            }
            block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                for (int j = 0; j < numBands; ++j) {
                    if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                    this.mustConvertToRGB = true;
                    continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public MosaicIndexBuilder() {
        super(NAME, VERSION);
        this.nameOpt = this.optionBuilder.withShortName("name").withLongName("index_name").withArgument(this.argumentBuilder.withName("name").withMinimum(0).withMaximum(1).create()).withDescription("name for the index file").withRequired(false).create();
        this.relativePathOpt = this.optionBuilder.withShortName("abs").withLongName("absolute_path").withDescription("whether or not paths shuld be absolute").withRequired(false).create();
        this.addOption(this.locationOpt);
        this.addOption(this.wildcardOpt);
        this.addOption(this.nameOpt);
        this.addOption(this.relativePathOpt);
        this.finishInitialization();
    }

    public static void main(String[] args) {
        MosaicIndexBuilder mosaicIndexBuilder = new MosaicIndexBuilder();
        mosaicIndexBuilder.addProcessingEventListener(mosaicIndexBuilder);
        if (mosaicIndexBuilder.parseArgs(args)) {
            Thread t = new Thread((Runnable)mosaicIndexBuilder, NAME);
            t.setPriority(mosaicIndexBuilder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.fine("Exiting...");
        }
    }

    @Override
    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.locationPath = (String)this.getOptionValue(this.locationOpt);
        File inDir = new File(this.locationPath);
        if (!inDir.isDirectory()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            return false;
        }
        try {
            this.locationPath = inDir.getCanonicalPath();
            this.locationPath = this.locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
        if (this.hasOption(this.wildcardOpt)) {
            this.wildcardString = (String)this.getOptionValue(this.wildcardOpt);
        }
        if (this.hasOption(this.nameOpt)) {
            this.indexName = (String)this.getOptionValue(this.nameOpt);
        }
        if (this.hasOption(this.relativePathOpt)) {
            this.absolute = true;
        }
        return true;
    }

    protected final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null) {
                MathTransform tr;
                CoordinateReferenceSystem crs2D = CRSUtilities.getCRS2D((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
                if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)crs2D) && !(tr = CRS.findMathTransform((CoordinateReferenceSystem)crs2D, (CoordinateReferenceSystem)crs)).isIdentity()) {
                    envelope = CRS.transform((MathTransform)tr, (org.opengis.geometry.Envelope)envelope);
                }
                requestedRes = new double[]{envelope.getLength(0) / dim.getWidth(), envelope.getLength(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to get the resolution", (Throwable)e);
        }
    }

    @Override
    public void getNotification(ProcessingEvent event) {
        LOGGER.info(new StringBuffer("Progress is at ").append(event.getPercentage()).append("\n").append("attached message is: ").append(event.getMessage()).toString());
    }

    @Override
    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    public final void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
        File inDir = new File(locationPath);
        if (!inDir.isDirectory()) {
            LOGGER.severe("Provided input dir does not exist or is not a dir!");
            throw new IllegalArgumentException("Provided input dir does not exist or is not a dir!");
        }
        try {
            locationPath = inDir.getCanonicalPath();
            locationPath = locationPath.replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public double getResolutionX() {
        return this.resolutionLevels[0][0];
    }

    public double getResolutionY() {
        return this.resolutionLevels[1][0];
    }
}

