/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class PropertyExistsFunction
extends FunctionExpressionImpl {
    public PropertyExistsFunction() {
        super("PropertyExists");
    }

    public int getArgCount() {
        return 1;
    }

    private String getPropertyName() {
        Expression expr = (Expression)this.getParameters().get(0);
        return this.getPropertyName(expr);
    }

    private String getPropertyName(Expression expr) {
        String propertyName;
        if (expr instanceof Literal) {
            propertyName = String.valueOf(((Literal)expr).getValue());
        } else if (expr instanceof PropertyName) {
            propertyName = ((PropertyName)expr).getPropertyName();
        } else {
            throw new IllegalStateException("Not a property name expression: " + expr);
        }
        return propertyName;
    }

    public Object evaluate(SimpleFeature feature) {
        String propName = this.getPropertyName();
        AttributeDescriptor attributeType = feature.getFeatureType().getDescriptor(propName);
        return attributeType != null;
    }

    public Object evaluate(Object bean) {
        if (bean instanceof SimpleFeature) {
            return this.evaluate((SimpleFeature)bean);
        }
        String propName = this.getPropertyName();
        Boolean propertyExists = Boolean.TRUE;
        try {
            PropertyUtils.getProperty((Object)bean, (String)propName);
        }
        catch (NoSuchMethodException e) {
            propertyExists = Boolean.FALSE;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return propertyExists;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PropertyExists('");
        sb.append(this.getPropertyName());
        sb.append("')");
        String stringVal = sb.toString();
        return stringVal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyExistsFunction)) {
            return false;
        }
        PropertyExistsFunction other = (PropertyExistsFunction)((Object)obj);
        if (other.getParameters().size() != this.getParameters().size()) {
            return false;
        }
        if (other.getParameters().size() > 0) {
            String propName = this.getPropertyName();
            Expression otherPropNameExpr = (Expression)other.getParameters().get(0);
            String otherPropName = this.getPropertyName(otherPropNameExpr);
            return Utilities.equals((Object)propName, (Object)otherPropName);
        }
        return true;
    }
}

