/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.commons.TokenAdapter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLFilterBuilder;
import org.geotools.filter.text.generated.parsers.CQLParser;
import org.geotools.filter.text.generated.parsers.Node;
import org.geotools.filter.text.generated.parsers.ParseException;
import org.geotools.filter.text.generated.parsers.TokenMgrError;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQLCompiler
extends CQLParser
implements ICompiler {
    private static final String ATTRIBUTE_PATH_SEPARATOR = "/";
    private final String source;
    private CQLFilterBuilder builder;

    public CQLCompiler(String cqlSource, FilterFactory filterFactory) {
        super(new StringReader(cqlSource));
        assert (cqlSource != null) : "cqlSource cannot be null";
        assert (filterFactory != null) : "filterFactory cannot be null";
        this.source = cqlSource;
        this.builder = new CQLFilterBuilder(cqlSource, filterFactory);
    }

    @Override
    public void compileFilter() throws CQLException {
        try {
            super.FilterCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileExpression() throws CQLException {
        try {
            super.ExpressionCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileFilterList() throws CQLException {
        try {
            super.FilterListCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    @Override
    public final Filter getFilter() throws CQLException {
        return this.builder.getFilter();
    }

    @Override
    public final Expression getExpression() throws CQLException {
        return this.builder.getExpression();
    }

    @Override
    public final List<Filter> getFilterList() throws CQLException {
        return this.builder.getFilterList();
    }

    @Override
    public IToken getTokenInPosition(int index) {
        return TokenAdapter.newAdapterFor(super.getToken(index));
    }

    @Override
    public final void jjtreeOpenNodeScope(Node n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void jjtreeCloseNodeScope(Node n) throws ParseException {
        try {
            Object built = this.build(n);
            IToken tokenAdapter = TokenAdapter.newAdapterFor(this.token);
            Result r = new Result(built, tokenAdapter, n.getType());
            this.builder.pushResult(r);
        }
        finally {
            n.dispose();
        }
    }

    private Object build(Node cqlNode) throws CQLException {
        switch (cqlNode.getType()) {
            case 53: {
                return this.builder.buildLiteralInteger(this.getToken((int)0).image);
            }
            case 54: {
                return this.builder.buildLiteralDouble(this.getToken((int)0).image);
            }
            case 57: {
                return this.builder.buildLiteralString(this.getToken((int)0).image);
            }
            case 49: {
                return this.builder.buildIdentifier(50);
            }
            case 50: {
                return this.builder.buildIdentifierPart(this.getTokenInPosition(0));
            }
            case 51: {
                return this.builder.buildSimpleAttribute();
            }
            case 52: {
                return this.builder.buildCompoundAttribute(51, ATTRIBUTE_PATH_SEPARATOR);
            }
            case 58: {
                return this.builder.buildFunction(59);
            }
            case 59: {
                return cqlNode;
            }
            case 60: {
                return cqlNode;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                return this.buildBinaryExpression(cqlNode.getType());
            }
            case 2: {
                return this.buildLogicFilter(2);
            }
            case 1: {
                return this.buildLogicFilter(1);
            }
            case 3: {
                return this.buildLogicFilter(3);
            }
            case 44: {
                return this.builder.buildBetween();
            }
            case 43: {
                return this.builder.buildNotBetween();
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.buildBinaryComparasionOperator(cqlNode.getType());
            }
            case 26: {
                BinaryComparisonOperator eq = this.buildBinaryComparasionOperator(21);
                Not notFilter = this.builder.buildNotFilter((Filter)eq);
                return notFilter;
            }
            case 42: {
                return this.builder.buildLikeFilter();
            }
            case 41: {
                return this.builder.buildNotLikeFilter();
            }
            case 27: {
                return this.builder.buildPropertyIsNull();
            }
            case 28: {
                return this.builder.buildPorpertyNotIsNull();
            }
            case 37: {
                return this.builder.buildDateTimeExpression(this.getTokenInPosition(0));
            }
            case 38: {
                return this.builder.buildDurationExpression(this.getTokenInPosition(0));
            }
            case 36: {
                return this.builder.buildPeriodBetweenDates();
            }
            case 35: {
                return this.builder.buildPeriodDateAndDuration();
            }
            case 34: {
                return this.builder.buildPeriodDurationAndDate();
            }
            case 29: {
                return this.buildTemporalPredicateBefore();
            }
            case 31: {
                return this.buildTemporalPredicateAfter();
            }
            case 32: {
                return this.buildTemporalPredicateDuring();
            }
            case 30: {
                return this.buildTemporalPredicateBeforeOrDuring();
            }
            case 33: {
                return this.buildTemporalPredicateDuringOrAfter();
            }
            case 39: {
                return this.builder.buildPropertyExists();
            }
            case 40: {
                PropertyIsEqualTo filter = this.builder.buildPropertyExists();
                Not filterPropNotExist = this.builder.buildNotFilter((Filter)filter);
                return filterPropNotExist;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.buildBinarySpatialOperator(cqlNode.getType());
            }
            case 13: 
            case 14: {
                return this.buildBBox(cqlNode.getType());
            }
            case 12: {
                throw new CQLException("Unsupported geooperation RELATE (is not implemented by GeoTools)", this.getTokenInPosition(0), this.source);
            }
            case 17: {
                return this.builder.buildTolerance();
            }
            case 18: {
                return this.builder.buildDistanceUnit(this.getTokenInPosition(0));
            }
            case 15: 
            case 16: {
                return this.buildDistanceBufferOperator(cqlNode.getType());
            }
            case 61: {
                return this.builder.buildGeometry(TokenAdapter.newAdapterFor(cqlNode.getToken()));
            }
            case 62: {
                return this.builder.buildEnvelop(TokenAdapter.newAdapterFor(cqlNode.getToken()));
            }
            case 19: {
                return Filter.INCLUDE;
            }
            case 20: {
                return Filter.EXCLUDE;
            }
            case 55: {
                return this.builder.buildTrueLiteral();
            }
            case 56: {
                return this.builder.buildFalseLiteral();
            }
        }
        return null;
    }

    private BinaryExpression buildBinaryExpression(int nodeType) throws CQLException {
        BinaryExpression expr = null;
        switch (nodeType) {
            case 45: {
                expr = this.builder.buildAddExpression();
                break;
            }
            case 46: {
                expr = this.builder.buildSubtractExression();
                break;
            }
            case 47: {
                expr = this.builder.buildMultiplyExpression();
                break;
            }
            case 48: {
                expr = this.builder.buildDivideExpression();
                break;
            }
        }
        return expr;
    }

    private Filter buildLogicFilter(int nodeType) throws CQLException {
        try {
            Filter logicFilter;
            switch (nodeType) {
                case 2: {
                    logicFilter = this.builder.buildAndFilter();
                    break;
                }
                case 1: {
                    logicFilter = this.builder.buildOrFilter();
                    break;
                }
                case 3: {
                    logicFilter = this.builder.buildNotFilter();
                    break;
                }
                default: {
                    throw new CQLException("Expression not supported. And, Or, Not is required", this.getTokenInPosition(0), this.source);
                }
            }
            return logicFilter;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building LogicFilter", this.getTokenInPosition(0), ife, this.source);
        }
    }

    private BinarySpatialOperator buildBinarySpatialOperator(int nodeType) throws CQLException {
        BinarySpatialOperator filter = null;
        switch (nodeType) {
            case 4: {
                filter = this.builder.buildSpatialEqualFilter();
                break;
            }
            case 5: {
                filter = this.builder.buildSpatialDisjointFilter();
                break;
            }
            case 6: {
                filter = this.builder.buildSpatialIntersectsFilter();
                break;
            }
            case 7: {
                filter = this.builder.buildSpatialTouchesFilter();
                break;
            }
            case 8: {
                filter = this.builder.buildSpatialCrossesFilter();
                break;
            }
            case 9: {
                filter = this.builder.buildSpatialWithinFilter();
                break;
            }
            case 10: {
                filter = this.builder.buildSpatialContainsFilter();
                break;
            }
            case 11: {
                filter = this.builder.buildSpatialOverlapsFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private BBOX buildBBox(int nodeType) throws CQLException {
        if (nodeType == 14) {
            return this.builder.buildBBoxWithCRS();
        }
        return this.builder.buildBBox();
    }

    private DistanceBufferOperator buildDistanceBufferOperator(int nodeType) throws CQLException {
        DistanceBufferOperator filter = null;
        switch (nodeType) {
            case 15: {
                filter = this.builder.buildSpatialDWithinFilter();
                break;
            }
            case 16: {
                filter = this.builder.buildSpatialBeyondFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateBeforeOrDuring() throws CQLException {
        PropertyIsLessThanOrEqualTo filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 34: 
            case 35: 
            case 36: {
                filter = this.builder.buildPropertyIsLTELastDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateDuringOrAfter() throws CQLException {
        PropertyIsGreaterThanOrEqualTo filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 34: 
            case 35: 
            case 36: {
                filter = this.builder.buildPropertyIsGTEFirstDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateBefore() throws CQLException {
        BinaryComparisonOperator filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 37: {
                filter = this.buildBinaryComparasionOperator(23);
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                filter = this.builder.buildPropertyIsLTFirsDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Object buildTemporalPredicateDuring() throws CQLException {
        And filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 34: 
            case 35: 
            case 36: {
                filter = this.builder.buildPropertyBetweenDates();
                break;
            }
            default: {
                throw new CQLException("unexpeted period expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Filter buildTemporalPredicateAfter() throws CQLException {
        BinaryComparisonOperator filter = null;
        Result result = this.builder.peekResult();
        switch (result.getNodeType()) {
            case 37: {
                filter = this.buildBinaryComparasionOperator(22);
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                filter = this.builder.buildPropertyIsGTLastDate();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", result.getToken(), this.source);
            }
        }
        return filter;
    }

    private BinaryComparisonOperator buildBinaryComparasionOperator(int filterType) throws CQLException {
        switch (filterType) {
            case 21: {
                return this.builder.buildEquals();
            }
            case 22: {
                return this.builder.buildGreater();
            }
            case 23: {
                return this.builder.buildLess();
            }
            case 24: {
                return this.builder.buildGreaterOrEqual();
            }
            case 25: {
                return this.builder.buildLessOrEqual();
            }
        }
        throw new CQLException("unexpeted filter type.");
    }

    public static void main(String[] args) throws ParseException {
        System.out.println("Expecting a predicate (q - quit).");
        block3: while (true) {
            try {
                while (true) {
                    InputStreamReader reader;
                    BufferedReader buf;
                    String source;
                    if ("q".equals(source = (buf = new BufferedReader(reader = new InputStreamReader(System.in))).readLine())) {
                        System.out.println("bye.");
                        break block3;
                    }
                    FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)null);
                    CQLCompiler compiler = new CQLCompiler(source, ff);
                    compiler.compileFilter();
                    Filter filter = compiler.getFilter();
                    System.out.println("Result: " + filter);
                }
            }
            catch (CQLException e) {
                System.out.println("Parsing error.");
                System.out.println(e.getSyntaxError());
                continue;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

