package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;

/**
 * A simple ShapeCreator that builds a 'X' shape.
 * @author fmoura
 */
public class TimesShapeCreator extends AbstractShapeCreator {
	public String getShapeName() {
		return "times";
	}
	
	public Shape createShape(Parameter<String>... parameters) {
		GeneralPath gp = new GeneralPath();
		gp.moveTo(-0.5f, 0.5f);
		gp.lineTo(0.5f, -0.5f);
		gp.moveTo(-0.5f, -0.5f);
		gp.lineTo(0.5f, 0.5f);
		return gp;
	}
}
