package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

import org.geotools.renderer.style.shape.ExplicitBoundsShape;


public class VerticalLineShapeCreator extends AbstractShapeCreator {
	public String getShapeName() {
		return "vertline";
	}

	public Shape createShape(Parameter<String>... parameters) {
		ExplicitBoundsShape shape = new ExplicitBoundsShape(new  Line2D.Double(0, -0.5, 0, 0.5));
		shape.setBounds(new Rectangle2D.Double(-0.5,0.5,1.0,1.0));
		return shape;
	}
	
    public String buildShapeSpecification()
    {
        return getShapeName();
    }  	
}
