/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.geotools.renderer.style.customshape.ShapeCreator;

public abstract class AbstractShapeCreator
implements ShapeCreator {
    private static Logger _logger = Logger.getLogger(AbstractShapeCreator.class);

    @Override
    public Shape createShape(String shapeSpecification) {
        int questionMarkIndex = shapeSpecification.indexOf("?");
        String name = questionMarkIndex >= 0 ? shapeSpecification.substring(0, questionMarkIndex) : shapeSpecification;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (!name.equalsIgnoreCase(this.getShapeName())) {
            return null;
        }
        ArrayList<Parameter<String>> parameters = new ArrayList<Parameter<String>>();
        this.parseParameters(shapeSpecification.substring(questionMarkIndex + 1), parameters);
        Parameter[] parametersArray = new Parameter[parameters.size()];
        int index = 0;
        Iterator i$ = parameters.iterator();
        while (i$.hasNext()) {
            Parameter parameter;
            parametersArray[index] = parameter = (Parameter)i$.next();
            ++index;
        }
        return this.createShape(parametersArray);
    }

    private void parseParameters(String urlEncodedParameters, Collection<Parameter<String>> parameters) {
        String[] encodedPairs;
        if ("".equals(urlEncodedParameters)) {
            return;
        }
        String encoding = "UTF-8";
        for (String encodedPair : encodedPairs = urlEncodedParameters.split("&")) {
            String[] nameAndValue = encodedPair.split("=");
            if (nameAndValue.length == 2) {
                try {
                    String name = URLDecoder.decode(nameAndValue[0], "UTF-8");
                    String value = URLDecoder.decode(nameAndValue[1], "UTF-8");
                    parameters.add(new Parameter<String>(name, value));
                }
                catch (UnsupportedEncodingException e) {
                    _logger.warn((Object)"Failed to decode a custom shape parameter.", (Throwable)e);
                }
                continue;
            }
            _logger.warn((Object)("Malformed custom shape parameter: \"" + encodedPair + "\"."));
        }
    }

    protected abstract Shape createShape(Parameter<String> ... var1);

    protected String buildShapeSpecification(Parameter<String> ... parameters) {
        String specification = this.getShapeName();
        if (parameters.length > 0) {
            specification = specification + "?";
            boolean first = true;
            for (Parameter<String> parameter : parameters) {
                if (!first) {
                    specification = specification + "&";
                }
                first = false;
                specification = specification + parameter.getName() + "=" + parameter.getValue();
            }
        }
        return specification;
    }

    protected static class Parameter<V> {
        private final String name;
        private final V value;

        public Parameter(String name, V value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public V getValue() {
            return this.value;
        }
    }
}

