/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.SortBy;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentFeatureCollection
implements FeatureCollection<SimpleFeatureType, SimpleFeature> {
    protected ContentFeatureSource featureSource;
    protected Query query;
    protected SimpleFeatureType featureType;
    protected ContentState state;
    protected List listeners = new ArrayList(2);
    protected final Set open = new HashSet();
    FeatureListener listener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            if (ContentFeatureCollection.this.listeners.isEmpty()) {
                return;
            }
            ContentFeatureCollection collection = ContentFeatureCollection.this;
            CollectionEvent event = new CollectionEvent((FeatureCollection)collection, featureEvent);
            CollectionListener[] notify = ContentFeatureCollection.this.listeners.toArray(new CollectionListener[ContentFeatureCollection.this.listeners.size()]);
            for (int i = 0; i < notify.length; ++i) {
                CollectionListener listener = notify[i];
                try {
                    listener.collectionChanged(event);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    };

    protected ContentFeatureCollection(ContentFeatureSource featureSource, Query query) {
        this.featureSource = featureSource;
        this.query = query;
        this.featureType = query.getPropertyNames() != Query.ALL_NAMES ? SimpleFeatureTypeBuilder.retype((SimpleFeatureType)featureSource.getSchema(), (String[])query.getPropertyNames()) : featureSource.getSchema();
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public void accepts(org.geotools.feature.visitor.FeatureVisitor visitor, org.geotools.util.ProgressListener progress) throws IOException {
        this.accepts((FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.featureSource.accepts(this.query, visitor, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CollectionListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                this.featureSource.addFeatureListener(this.listener);
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CollectionListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.featureSource.removeFeatureListener(this.listener);
            }
        }
    }

    public FeatureIterator<SimpleFeature> features() {
        try {
            return new WrappingFeatureIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close(FeatureIterator<SimpleFeature> iterator) {
        iterator.close();
    }

    public Iterator iterator() {
        try {
            return new WrappingIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close(Iterator close) {
        try {
            ((WrappingIterator)close).delegate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferencedEnvelope getBounds() {
        try {
            return this.featureSource.getBounds(this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        try {
            return this.featureSource.getCount(this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(SimpleFeature o) {
        return this.addAll(Collections.singletonList(o));
    }

    ContentFeatureStore ensureFeatureStore() {
        if (this.featureSource instanceof ContentFeatureStore) {
            return (ContentFeatureStore)this.featureSource;
        }
        throw new UnsupportedOperationException("read only");
    }

    public boolean addAll(Collection c) {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            List<FeatureId> ids = featureStore.addFeatures(c);
            return ids.size() == c.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean addAll(FeatureCollection c) {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            List<FeatureId> ids = featureStore.addFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)c);
            return ids.size() == c.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            featureStore.removeFeatures(this.query.getFilter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void purge() {
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> sort(SortBy order) {
        return this.sort((org.opengis.filter.sort.SortBy)order);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> sort(org.opengis.filter.sort.SortBy sort) {
        DefaultQuery query = new DefaultQuery();
        query.setSortBy(new org.opengis.filter.sort.SortBy[]{sort});
        query = DataUtilities.mixQueries((Query)this.query, (Query)query, null);
        return new ContentFeatureCollection(this.featureSource, (Query)query);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> subCollection(Filter filter) {
        DefaultQuery query = new DefaultQuery();
        query.setFilter(filter);
        query = DataUtilities.mixQueries((Query)this.query, (Query)query, null);
        return new ContentFeatureCollection(this.featureSource, (Query)query);
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray(Object[] array) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(Name name) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(int indedx) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    public List<Object> getAttributes() {
        throw new UnsupportedOperationException();
    }

    public Object getDefaultGeometry() {
        throw new UnsupportedOperationException();
    }

    public SimpleFeatureType getFeatureType() {
        throw new UnsupportedOperationException();
    }

    public SimpleFeatureType getType() {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(Name name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(int index, Object value) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    public void setAttributes(List<Object> attributes) {
        throw new UnsupportedOperationException();
    }

    public void setAttributes(Object[] attributes) {
        throw new UnsupportedOperationException();
    }

    public void setDefaultGeometry(Object defaultGeometry) {
        throw new UnsupportedOperationException();
    }

    public GeometryAttribute getDefaultGeometryProperty() {
        throw new UnsupportedOperationException();
    }

    public FeatureId getIdentifier() {
        throw new UnsupportedOperationException();
    }

    public String getID() {
        throw new UnsupportedOperationException();
    }

    public void setDefaultGeometryProperty(GeometryAttribute defaultGeometryProperty) {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties() {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties(Name name) {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties(String name) {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(Name name) {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Property> getValue() {
        throw new UnsupportedOperationException();
    }

    public void setValue(Collection<Property> value) {
        throw new UnsupportedOperationException();
    }

    public AttributeDescriptor getDescriptor() {
        throw new UnsupportedOperationException();
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public Map<Object, Object> getUserData() {
        throw new UnsupportedOperationException();
    }

    public boolean isNillable() {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public void validate() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappingIterator
    implements Iterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object next() {
            try {
                return this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappingFeatureIterator
    implements FeatureIterator<SimpleFeature> {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public SimpleFeature next() throws NoSuchElementException {
            try {
                return (SimpleFeature)this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

