/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.db2.DB2DataStore;
import org.geotools.data.db2.DB2SQLBuilder;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2FeatureSource
extends JDBCFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");

    public DB2FeatureSource(DB2DataStore dataStore, SimpleFeatureType featureType) {
        super((JDBC1DataStore)dataStore, featureType);
    }

    protected void closeAll(ResultSet rs, Statement stmt, Connection conn, Transaction transaction, SQLException e) {
        this.close(rs);
        this.close(stmt);
        this.close(conn, transaction, e);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        ReferencedEnvelope env = new ReferencedEnvelope();
        CoordinateReferenceSystem crs = null;
        LOGGER.fine("Query: " + query.toString());
        if (this.getSchema() != null) {
            String typeName = this.getSchema().getTypeName();
            GeometryDescriptor geomType = this.getSchema().getGeometryDescriptor();
            if (geomType != null) {
                Filter filter = query.getFilter();
                Class<?> filterClass = filter.getClass();
                if (filterClass == Intersects.class || filterClass == BBOX.class) {
                    filter = this.fixNullGeomFilter(filter);
                }
                if (filter != Filter.EXCLUDE) {
                    String sqlStmt = null;
                    try {
                        DB2SQLBuilder builder = (DB2SQLBuilder)((DB2DataStore)this.getDataStore()).getSqlBuilder(typeName);
                        LOGGER.fine("Filter: " + filter.toString());
                        sqlStmt = builder.buildSQLBoundsQuery(typeName, (AttributeDescriptor)geomType, filter);
                    }
                    catch (SQLEncoderException e) {
                        throw new IOException("SQLEncoderException: " + (Object)((Object)e));
                    }
                    Connection conn = null;
                    Transaction transaction = null;
                    Statement statement = null;
                    ResultSet results = null;
                    try {
                        conn = this.getConnection();
                        transaction = this.getTransaction();
                        statement = conn.createStatement();
                        results = statement.executeQuery(sqlStmt);
                        if (results.next()) {
                            double minx = results.getDouble(1);
                            double miny = results.getDouble(2);
                            double maxx = results.getDouble(3);
                            double maxy = results.getDouble(4);
                            env = new ReferencedEnvelope(minx, maxx, miny, maxy, null);
                        } else {
                            env = new ReferencedEnvelope();
                        }
                    }
                    catch (SQLException e) {
                        this.closeAll(results, statement, conn, transaction, e);
                        System.out.println(e);
                        throw new DataSourceException("Could not get bounds " + query.getHandle(), (Throwable)e);
                    }
                    this.closeAll(results, statement, conn, transaction, null);
                }
                crs = geomType.getCoordinateReferenceSystem();
                env = new ReferencedEnvelope((Envelope)env, crs);
            }
        }
        LOGGER.fine("Bounds: " + env.toString());
        return env;
    }

    private Filter fixNullGeomFilter(Filter inFilter) {
        BinarySpatialOperator operator = (BinarySpatialOperator)inFilter;
        Filter filter = inFilter;
        Class<?> filterClass = inFilter.getClass();
        double xmin = 0.0;
        double ymin = 0.0;
        double xmax = 0.0;
        double ymax = 0.0;
        if (operator.getExpression1() == null) {
            String attName = null;
            GeometryDescriptor dg = this.getSchema().getGeometryDescriptor();
            if (dg != null) {
                attName = dg.getLocalName();
            }
            if (attName != null) {
                FilterFactory2 ff = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);
                if (filterClass == Intersects.class) {
                    Intersects intersects = (Intersects)inFilter;
                    Literal geomLiteral = (Literal)intersects.getExpression2();
                    Geometry geom = (Geometry)geomLiteral.getValue();
                    Envelope envelope = geom.getEnvelopeInternal();
                    xmin = envelope.getMinX();
                    ymin = envelope.getMinY();
                    xmax = envelope.getMaxX();
                    ymax = envelope.getMaxY();
                    PropertyName name = ff.property(attName);
                    filter = ff.intersects((Expression)name, (Expression)geomLiteral);
                } else if (filterClass == BBOX.class) {
                    BBOX bbox = (BBOX)inFilter;
                    xmin = bbox.getMinX();
                    ymin = bbox.getMinY();
                    xmax = bbox.getMaxX();
                    ymax = bbox.getMaxY();
                }
                filter = ff.bbox(attName, xmin, ymin, xmax, ymax, "");
            }
        }
        return filter;
    }
}

