/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.db2.filter.SQLEncoderDB2;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.GeoAPISQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.filter.SQLEncoderException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2SQLBuilder
extends GeoAPISQLBuilder {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");
    private String tableSchema = null;
    private String tableName = null;
    private FIDMapper mapper = null;

    public DB2SQLBuilder(FilterToSQL encoder, String tableSchema, SimpleFeatureType featureType, FIDMapper mapper) {
        super(encoder, featureType, null);
        this.tableSchema = tableSchema;
        this.mapper = mapper;
        this.tableName = featureType.getTypeName();
    }

    public void sqlGeometryColumn(StringBuffer sql, AttributeDescriptor geomAttribute) {
        sql.append("DB2GSE.ST_AsBinary(" + this.sqlGeometryColumnName(geomAttribute) + ")");
    }

    String sqlGeometryColumnName(AttributeDescriptor geomAttribute) {
        return this.encoder.escapeName(geomAttribute.getLocalName());
    }

    String sqlGeometryMinMaxValues(AttributeDescriptor geomAttribute) {
        String gcName = this.sqlGeometryColumnName(geomAttribute);
        String sql = "MIN(db2gse.ST_MinX(" + gcName + ")), " + "MIN(db2gse.ST_MinY(" + gcName + ")), " + "MAX(db2gse.ST_MaxX(" + gcName + ")), " + "MAX(db2gse.ST_MaxY(" + gcName + ")) ";
        return sql;
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.getSchemaTableName(typeName));
    }

    public String buildSQLBoundsQuery(String typeName, AttributeDescriptor geomAttr, Filter filter) throws SQLEncoderException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        sqlBuffer.append(this.sqlGeometryMinMaxValues(geomAttr));
        this.sqlFrom(sqlBuffer, typeName);
        this.sqlWhere(sqlBuffer, filter);
        String sqlStmt = sqlBuffer.toString();
        LOGGER.finer(sqlStmt);
        return sqlStmt;
    }

    SQLEncoderDB2 getEncoder() {
        return (SQLEncoderDB2)this.encoder;
    }

    String getSchemaTableName(String tableName) {
        return String.valueOf(this.escapeName(this.tableSchema)) + "." + this.escapeName(tableName);
    }

    String getSchemaTableName() {
        return String.valueOf(this.escapeName(this.tableSchema)) + "." + this.escapeName(this.tableName);
    }

    String escapeName(String name) {
        return this.encoder.escapeName(name);
    }

    protected String makeInsertSql(List<AttributeDescriptor> attributes, SimpleFeature feature) throws IOException {
        SQLEncoderDB2 db2Encoder = (SQLEncoderDB2)this.encoder;
        String attrValue = null;
        boolean firstAttr = true;
        StringBuffer colNameList = new StringBuffer("");
        StringBuffer valueList = new StringBuffer("");
        int i = 0;
        while (i < attributes.size()) {
            String colName = this.escapeName(attributes.get(i).getLocalName());
            if (!firstAttr) {
                colNameList.append(", ");
                valueList.append(", ");
            }
            firstAttr = false;
            colNameList.append(colName);
            Object currAtt = feature.getAttribute(i);
            attrValue = currAtt == null ? "NULL" : (Geometry.class.isAssignableFrom(attributes.get(i).getType().getBinding()) ? db2Encoder.db2Geom((Geometry)currAtt) : (String.class.isAssignableFrom(attributes.get(i).getType().getBinding()) ? "'" + currAtt.toString() + "'" : currAtt.toString()));
            valueList.append(attrValue);
            ++i;
        }
        String statementSQL = "INSERT INTO " + this.getSchemaTableName() + "( " + colNameList.toString() + ")" + " VALUES(" + valueList.toString() + ")";
        return statementSQL;
    }

    protected String makeUpdateSql(List<AttributeDescriptor> attributes, SimpleFeature live, SimpleFeature current) throws IOException {
        boolean firstAttr = true;
        SQLEncoderDB2 db2Encoder = (SQLEncoderDB2)this.encoder;
        StringBuffer statementSQL = new StringBuffer("UPDATE " + this.getSchemaTableName() + " SET ");
        int i = 0;
        while (i < current.getAttributeCount()) {
            Object liveAtt;
            Object currAtt = current.getAttribute(i);
            if (!DataUtilities.attributesEqual((Object)currAtt, (Object)(liveAtt = live.getAttribute(i)))) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.fine("modifying att# " + i + " to " + currAtt);
                }
                String attrValue = null;
                String attrName = attributes.get(i).getLocalName();
                attrValue = Geometry.class.isAssignableFrom(attributes.get(i).getType().getBinding()) ? db2Encoder.db2Geom((Geometry)currAtt) : (String.class.isAssignableFrom(attributes.get(i).getType().getBinding()) ? "'" + currAtt.toString() + "'" : currAtt.toString());
                String colName = this.escapeName(attrName);
                if (!firstAttr) {
                    statementSQL.append(", ");
                }
                firstAttr = false;
                statementSQL.append(colName).append(" = ").append(attrValue);
            }
            ++i;
        }
        statementSQL.append(this.makeFIDWhere(current));
        return statementSQL.toString();
    }

    public String makeDeleteSql(SimpleFeature feature) throws IOException {
        String deleteSQL = "DELETE FROM " + this.getSchemaTableName() + this.makeFIDWhere(feature);
        return deleteSQL;
    }

    protected String makeFIDWhere(SimpleFeature feature) throws IOException {
        StringBuffer statementSQL = new StringBuffer(" WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(feature.getID());
        if (this.mapper.getColumnCount() == 0) {
            throw new UnsupportedOperationException();
        }
        boolean firstCol = true;
        int i = 0;
        while (i < this.mapper.getColumnCount()) {
            if (!firstCol) {
                statementSQL.append(" AND ");
                firstCol = false;
            }
            statementSQL.append(this.escapeName(this.mapper.getColumnName(i))).append(" = ");
            if (this.isTypeNumeric(this.mapper.getColumnType(i))) {
                statementSQL.append(pkValues[i]);
            } else {
                statementSQL.append("'" + pkValues[i] + "'");
            }
            ++i;
        }
        return statementSQL.toString();
    }

    protected boolean isTypeNumeric(int columnType) {
        boolean numeric = false;
        if (columnType == -7 || columnType == -6 || columnType == 5 || columnType == 4 || columnType == -5 || columnType == 6 || columnType == 7 || columnType == 8 || columnType == 2 || columnType == 3) {
            numeric = true;
        }
        return numeric;
    }
}

