/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.db2.DB2CoordinateSystem;
import org.geotools.data.db2.DB2GeometryColumn;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2SpatialCatalog {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");
    private static Map catalogs = new HashMap();
    private Map geometryColumns;
    private Map coordinateSystems = new HashMap();
    private String dbURL;
    private String tableSchema;

    private DB2SpatialCatalog(String dbURL, String tableSchema) {
        this.dbURL = dbURL;
        this.tableSchema = tableSchema;
    }

    public static void reset() {
        catalogs = new HashMap();
    }

    public static DB2SpatialCatalog getInstance(String dbURL, String tableSchema, Connection conn) throws SQLException {
        DB2SpatialCatalog catalog = (DB2SpatialCatalog)catalogs.get(dbURL + tableSchema);
        if (catalog == null && conn != null) {
            catalog = new DB2SpatialCatalog(dbURL, tableSchema);
            catalog.loadCatalog(conn, tableSchema);
            catalogs.put(dbURL + tableSchema, catalog);
        }
        return catalog;
    }

    public static String geomID(String tableSchema, String tableName, String columnName) {
        String key = tableSchema + "." + tableName + "(" + columnName + ")";
        return key;
    }

    void loadCatalog(Connection conn, String schemaName) throws SQLException {
        this.geometryColumns = new HashMap();
        String queryGeom = "SELECT table_schema, table_name, column_name,  type_name, srs_id FROM db2gse.st_geometry_columns WHERE table_schema = '" + schemaName + "' ";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(queryGeom);
        while (rs.next()) {
            DB2CoordinateSystem cs;
            String tableSchema = rs.getString(1).trim();
            String tableName = rs.getString(2).trim();
            String columnName = rs.getString(3).trim();
            String typeName = rs.getString(4).trim();
            Integer srsId = new Integer(rs.getInt(5));
            if (rs.wasNull()) {
                srsId = this.getSridFromTable(conn, tableSchema, tableName, columnName);
            }
            if ((cs = (DB2CoordinateSystem)this.coordinateSystems.get(srsId)) == null) {
                cs = new DB2CoordinateSystem(conn, srsId);
                this.coordinateSystems.put(srsId, cs);
            }
            DB2GeometryColumn gc = new DB2GeometryColumn(tableSchema, tableName, columnName, typeName, srsId, cs);
            LOGGER.fine("Spatial column: " + gc + " " + cs);
            this.geometryColumns.put(this.geomKey(gc), gc);
        }
        rs.close();
        stmt.close();
    }

    private Integer getSridFromTable(Connection conn, String tableSchema, String tableName, String columnName) throws SQLException {
        Integer srsId = new Integer(0);
        String querySrid = "SELECT DB2GSE.ST_SRID(\"" + columnName + "\")" + " FROM \"" + tableSchema + "\".\"" + tableName + "\"" + " WHERE \"" + columnName + "\" IS NOT NULL" + " FETCH FIRST ROW ONLY";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(querySrid);
        while (rs.next()) {
            srsId = new Integer(rs.getInt(1));
        }
        return srsId;
    }

    private String geomKey(DB2GeometryColumn gc) {
        String key = this.dbURL + ":" + gc.getTableSchema() + "." + gc.getTableName() + "." + gc.getColumnName();
        return key;
    }

    private String geomKey(String tableSchema, String tableName, String columnName) {
        String key = this.dbURL + ":" + tableSchema + "." + tableName + "." + columnName;
        return key;
    }

    String[] getTypeNames() {
        HashSet<String> typeNames = new HashSet<String>();
        for (DB2GeometryColumn gc : this.geometryColumns.values()) {
            typeNames.add(gc.getTableName());
        }
        return typeNames.toArray(new String[typeNames.size()]);
    }

    String getDB2GeometryTypeName(String tableSchema, String tableName, String columnName) throws IOException {
        return this.getGeometryColumn(tableSchema, tableName, columnName).getTypeName();
    }

    int getCsId(String tableSchema, String tableName, String columnName) throws IOException {
        return this.getGeometryColumn(tableSchema, tableName, columnName).getCsId();
    }

    CoordinateReferenceSystem getCRS(String tableSchema, String tableName, String columnName) throws FactoryRegistryException, FactoryException, IOException {
        return this.getGeometryColumn(tableSchema, tableName, columnName).getCRS();
    }

    int getSRID(String tableSchema, String tableName, String columnName) throws IOException {
        return this.getGeometryColumn(tableSchema, tableName, columnName).getSrsId();
    }

    private DB2GeometryColumn getGeometryColumn(String tableSchema, String tableName, String columnName) throws IOException {
        String geomKey = this.geomKey(tableSchema, tableName, columnName);
        DB2GeometryColumn gc = (DB2GeometryColumn)this.geometryColumns.get(geomKey);
        if (gc == null) {
            throw new IOException("Geometry not found: " + geomKey);
        }
        return gc;
    }

    public String toString() {
        return this.dbURL + "-" + this.tableSchema;
    }
}

