/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.directory.DataStoreSoftReference;
import org.geotools.data.directory.DirectoryDataStoreFactory;
import org.geotools.data.directory.DirectoryWatcher;
import org.geotools.data.directory.FactoryAdapter;
import org.geotools.data.directory.ImmediateDirectoryWatcher;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryTypeCache {
    static final Logger LOGGER = Logging.getLogger(DirectoryTypeCache.class);
    Map<String, FileEntry> ftCache = new ConcurrentHashMap<String, FileEntry>();
    File directory;
    URI namespaceURI;
    DirectoryWatcher watcher;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    DirectoryTypeCache(File directory, URI namespaceURI) throws IOException {
        if (directory == null) {
            throw new NullPointerException("Directory parameter should be not null");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Specified directory does not exists: " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory, it'a s file instead: " + directory.getAbsolutePath());
        }
        this.directory = directory;
        this.namespaceURI = namespaceURI;
        this.watcher = new ImmediateDirectoryWatcher(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataStore getDataStore(String typeName, boolean forceUpdate) throws IOException {
        this.lock.readLock().lock();
        try {
            if (forceUpdate) {
                this.updateCache();
            }
            DataStore dataStore = this.ftCache.get(typeName).getStore(true);
            return dataStore;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getTypeNames() throws IOException {
        this.lock.readLock().lock();
        try {
            this.updateCache();
            Set<String> set = this.ftCache.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataStore> getDataStores() {
        ArrayList<DataStore> stores = new ArrayList<DataStore>();
        this.lock.readLock().lock();
        try {
            for (FileEntry entry : this.ftCache.values()) {
                try {
                    DataStore store = entry.getStore(false);
                    if (store == null) continue;
                    stores.add(store);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error occurred trying to grab a datastore", e);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return stores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() throws IOException {
        if (this.watcher.isStale()) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.watcher.isStale()) {
                    this.watcher.mark();
                    this.refreshCacheContents();
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    void refreshCacheContents() throws IOException {
        DataStore store;
        TreeMap<String, FileEntry> result = new TreeMap<String, FileEntry>();
        HashMap<File, FileEntry> fileCache = new HashMap<File, FileEntry>();
        HashSet<FileEntry> dirCache = new HashSet<FileEntry>();
        for (FileEntry entry : this.ftCache.values()) {
            if (!entry.file.isDirectory()) {
                fileCache.put(entry.file, entry);
                continue;
            }
            dirCache.add(entry);
        }
        List<FactoryAdapter> factories = this.lookupFileDataStores();
        LOGGER.log(Level.FINE, "Found the following file capable factories: {0}", factories);
        TreeSet<File> files = new TreeSet<File>(Arrays.asList(this.directory.listFiles(new DirectoryFilter())));
        for (FactoryAdapter factoryAdapter : factories) {
            store = factoryAdapter.getStore(this.directory, this.namespaceURI);
            if (store == null) continue;
            FileEntry entry = null;
            for (FileEntry cachedEntry : dirCache) {
                if (!cachedEntry.getStore(true).getClass().equals(store.getClass())) continue;
                entry = cachedEntry;
                break;
            }
            if (entry == null) {
                entry = new FileEntry(this.directory, factoryAdapter, store);
            }
            if (entry == null) continue;
            for (String typeName : entry.getStore(true).getTypeNames()) {
                if (!result.containsKey(typeName)) {
                    result.put(typeName, entry);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Type name " + typeName + " is available from multiple datastores");
            }
        }
        while (!files.isEmpty()) {
            File curr = files.first();
            FileEntry entry = (FileEntry)fileCache.get(curr);
            if (entry == null) {
                store = null;
                FactoryAdapter adapter = null;
                Iterator<FactoryAdapter> i$ = factories.iterator();
                while (i$.hasNext()) {
                    FactoryAdapter factoryAdapter;
                    adapter = factoryAdapter = i$.next();
                    store = factoryAdapter.getStore(curr, this.namespaceURI);
                    if (store == null) continue;
                    break;
                }
                if (store != null) {
                    entry = new FileEntry(curr, adapter, store);
                }
            }
            if (entry != null) {
                for (String typeName : entry.getStore(true).getTypeNames()) {
                    if (!result.containsKey(typeName)) {
                        result.put(typeName, entry);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Type name " + typeName + " is available from multiple datastores");
                }
            } else {
                LOGGER.log(Level.FINE, "Could not find any datastore able to process {0}", curr);
            }
            files.remove(curr);
        }
        HashSet<String> removed = new HashSet<String>(this.ftCache.keySet());
        removed.removeAll(result.keySet());
        HashSet<FileEntry> disposable = new HashSet<FileEntry>();
        for (String removedFT : removed) {
            FileEntry entry = this.ftCache.get(removedFT);
            disposable.add(entry);
            this.ftCache.remove(removedFT);
        }
        for (FileEntry entry : result.values()) {
            disposable.remove(entry);
        }
        for (FileEntry entry : disposable) {
            entry.dispose();
        }
        HashSet added = new HashSet(result.keySet());
        added.removeAll(this.ftCache.keySet());
        for (String newFeatureType : added) {
            this.ftCache.put(newFeatureType, (FileEntry)result.get(newFeatureType));
        }
    }

    List<FactoryAdapter> lookupFileDataStores() {
        ArrayList<FactoryAdapter> adapters = new ArrayList<FactoryAdapter>();
        Iterator it = DataStoreFinder.getAllDataStores();
        while (it.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)it.next();
            DataAccessFactory.Param[] params = factory.getParametersInfo();
            if (params == null) {
                LOGGER.fine("DataStore factory " + factory + " returns null from getParametersInfo!");
                continue;
            }
            if (factory instanceof DirectoryDataStoreFactory) continue;
            DataAccessFactory.Param fileParam = null;
            DataAccessFactory.Param nsParam = null;
            for (DataAccessFactory.Param param : params) {
                Class type = param.type;
                String key = param.key;
                if (File.class.isAssignableFrom(type) || URL.class.isAssignableFrom(type)) {
                    fileParam = param;
                    continue;
                }
                if (!key.equalsIgnoreCase("namespace") || !String.class.isAssignableFrom(type) && !URI.class.isAssignableFrom(type)) continue;
                nsParam = param;
            }
            if (fileParam == null) continue;
            adapters.add(new FactoryAdapter(factory, fileParam, nsParam));
        }
        return adapters;
    }

    void dispose() {
        for (FileEntry entry : this.ftCache.values()) {
            entry.dispose();
        }
    }

    class FileEntry {
        File file;
        SoftReference<DataStore> ref;
        FactoryAdapter adapter;

        public FileEntry(File file, FactoryAdapter adapter, DataStore store) {
            this.file = file;
            this.adapter = adapter;
            this.ref = new DataStoreSoftReference(store);
        }

        DataStore getStore(boolean force) throws IOException {
            DataStore store;
            DataStore dataStore = store = this.ref != null ? this.ref.get() : null;
            if (store == null && force) {
                store = this.adapter.getStore(this.file, DirectoryTypeCache.this.namespaceURI);
                this.ref = new DataStoreSoftReference(store);
            }
            return store;
        }

        void dispose() {
            DataStore store;
            DataStore dataStore = store = this.ref != null ? this.ref.get() : null;
            if (store != null) {
                store.dispose();
            }
            this.ref.clear();
        }
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    }
}

