/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.directory.DirectoryDataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "Directory containing geospatial files", true);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters for DirectoryDataStore");
        }
        URL url = (URL)URLP.lookUp(params);
        File f = DataUtilities.urlToFile((URL)url);
        if (!f.isDirectory()) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.URLP.key + " : is not a valid directory");
        }
        URI namespace = (URI)NAMESPACE.lookUp(params);
        return new DirectoryDataStore(f, namespace);
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters for DirectoryDataStore");
        }
        return this.createDataStore(params);
    }

    public String getDisplayName() {
        return "Directory of spatial files";
    }

    public String getDescription() {
        return "Takes a directory of spatial data files and exposes it as a data store";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, NAMESPACE};
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            URL url = (URL)URLP.lookUp(params);
            File f = DataUtilities.urlToFile((URL)url);
            return f != null && f.exists() && f.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

