/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.referencing.factory.epsg.SqlScriptReader;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.h2.jdbcx.JdbcDataSource;

public class ThreadedH2EpsgFactory
extends ThreadedEpsgFactory {
    public static final Version VERSION = new Version("7.1.0");
    public static final String DIRECTORY_KEY = "EPSG-H2.directory";
    public static final String DATABASE_NAME = "EPSG";
    private static final String PREFIX = "jdbc:h2:";
    private static final String LOGGER = "org.geotools.referencing.factory.epsg";

    public ThreadedH2EpsgFactory() {
        this(null);
    }

    public ThreadedH2EpsgFactory(Hints hints) {
        super(hints, 91);
    }

    private static File getDirectory() {
        try {
            File directory;
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && ((directory = new File(property)).isDirectory() || directory.mkdir())) {
                return directory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ThreadedH2EpsgFactory.getTemporaryDirectory();
    }

    public static boolean isUnpacked() {
        File directory;
        try {
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && (directory = new File(property)).exists() && directory.isDirectory()) {
                return true;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        File temp = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        directory = new File(temp, "Databases/EPSG-H2-" + VERSION + "/");
        return directory.exists() && directory.isDirectory();
    }

    private static File getTemporaryDirectory() {
        File directory = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Databases/EPSG-H2-" + VERSION + "/")).isDirectory() || directory.mkdirs())) {
            return directory;
        }
        return null;
    }

    private static File getDirectory(DataSource source) {
        String path;
        if (source instanceof JdbcDataSource && (path = ((JdbcDataSource)source).getURL()) != null && PREFIX.regionMatches(true, 0, path, 0, PREFIX.length())) {
            if ((path = path.substring(PREFIX.length())).indexOf(59) != -1) {
                path = path.substring(0, path.indexOf(59));
            }
            return new File(path).getParentFile();
        }
        return null;
    }

    protected DataSource createDataSource() throws SQLException {
        DataSource candidate = super.createDataSource();
        if (candidate instanceof JdbcDataSource) {
            return candidate;
        }
        JdbcDataSource source = new JdbcDataSource();
        File directory = ThreadedH2EpsgFactory.getDirectory();
        if (directory != null) {
            StringBuilder url = new StringBuilder(PREFIX);
            String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            url.append(DATABASE_NAME);
            url.append(";AUTO_RECONNECT=TRUE;CACHE_SIZE=131072;CACHE_TYPE=TQ");
            source.setURL("jdbc:h2:zip:/tmp/EPSG3.ZIP!/EPSG");
            source.setURL(url.toString());
            source.setUser("sa");
            source.setPassword("");
            assert (directory.equals(ThreadedH2EpsgFactory.getDirectory((DataSource)source))) : url;
        }
        source.setUser("SA");
        return source;
    }

    private static boolean dataExists(Connection connection) throws SQLException {
        ResultSet tables = connection.getMetaData().getTables(null, null, "EPSG_%", new String[]{"TABLE"});
        boolean exists = tables.next();
        tables.close();
        return exists;
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        DataSource source = this.getDataSource();
        File directory = ThreadedH2EpsgFactory.getDirectory(source);
        Connection connection = source.getConnection();
        if (!ThreadedH2EpsgFactory.dataExists(connection)) {
            Logger logger = Logging.getLogger((String)LOGGER);
            LogRecord record = Loggings.format((Level)Level.INFO, (int)46, (Object)VERSION);
            record.setLoggerName(logger.getName());
            logger.log(record);
            Statement statement = connection.createStatement();
            try {
                this.executeScript("EPSG_Tables_PostgreSQL.sql", statement);
                this.executeScript("EPSG_Data_PostgreSQL.sql", statement);
                this.executeScript("EPSG_FKeys_PostgreSQL.sql", statement);
                this.executeScript("EPSG_Indexes_H2.sql", statement);
            }
            catch (IOException exception) {
                SQLException e = new SQLException("Error occurred while executing the EPSG database creation scripts");
                e.initCause(exception);
                throw e;
            }
            finally {
                statement.close();
            }
            statement.close();
            connection.close();
            this.setReadOnly(directory);
            connection = source.getConnection();
            assert (ThreadedH2EpsgFactory.dataExists(connection));
        }
        FactoryUsingAnsiSQL factory = new FactoryUsingAnsiSQL(hints, connection);
        return factory;
    }

    private void setReadOnly(File directory) {
        if (directory == null) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.setReadOnly(file);
                continue;
            }
            if (file.getName().endsWith(".log.db")) {
                file.delete();
                continue;
            }
            file.setReadOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeScript(String scriptName, Statement statement) throws IOException, SQLException {
        SqlScriptReader reader = null;
        try {
            reader = new SqlScriptReader(new InputStreamReader((InputStream)new GZIPInputStream(ThreadedH2EpsgFactory.class.getResourceAsStream(scriptName + ".gz")), "ISO-8859-15"));
            while (reader.hasNext()) {
                statement.execute(reader.next());
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }
}

