/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen.info;

import java.io.IOException;
import org.geotools.data.gen.info.GeneralizationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generalization
implements Comparable<Generalization> {
    private Double distance;
    private String featureName;
    private String geomPropertyName;
    private String dataSourceName;
    private String dataSourceNameSpace;
    private GeneralizationInfo parent;

    public Generalization(Double distance, String featureName, String geomPropertyName, GeneralizationInfo parent) {
        this.distance = distance;
        this.featureName = featureName;
        this.geomPropertyName = geomPropertyName;
        this.parent = parent;
    }

    public Double getDistance() {
        return this.distance;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getGeomPropertyName() {
        return this.geomPropertyName;
    }

    @Override
    public int compareTo(Generalization other) {
        return this.getDistance().compareTo(other.getDistance());
    }

    public String getDataSourceName() {
        if (this.dataSourceName != null) {
            return this.dataSourceName;
        }
        return this.parent.getDataSourceName();
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceNameSpace() {
        if (this.dataSourceNameSpace != null) {
            return this.dataSourceNameSpace;
        }
        return this.parent.getDataSourceNameSpace();
    }

    public void setDataSourceNameSpace(String namespace) {
        this.dataSourceNameSpace = namespace;
    }

    public void validate() throws IOException {
        if (this.getDataSourceName() == null) {
            throw new IOException("Datasource name missing");
        }
        if (this.getFeatureName() == null) {
            throw new IOException("Feature name missing");
        }
        if (this.getGeomPropertyName() == null) {
            throw new IOException("Geometry property name missing");
        }
    }
}

