/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geojson.GeoJSONUtil;
import org.geotools.geojson.feature.AttributeIO;
import org.geotools.geojson.feature.CRSHandler;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.geotools.geojson.feature.FeatureCollectionHandler;
import org.geotools.geojson.feature.FeatureHandler;
import org.geotools.geojson.feature.FeatureTypeAttributeIO;
import org.geotools.geojson.feature.IFeatureCollectionHandler;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONStreamAware;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureJSON {
    GeometryJSON gjson;
    SimpleFeatureType featureType;
    AttributeIO attio;
    boolean encodeFeatureBounds = false;
    boolean encodeFeatureCollectionBounds = false;
    boolean encodeFeatureCRS = false;
    boolean encodeFeatureCollectionCRS = false;

    public FeatureJSON() {
        this(new GeometryJSON());
    }

    public FeatureJSON(GeometryJSON gjson) {
        this.gjson = gjson;
        this.attio = new DefaultAttributeIO();
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
        this.attio = new FeatureTypeAttributeIO(featureType);
    }

    public void setEncodeFeatureBounds(boolean encodeFeatureBounds) {
        this.encodeFeatureBounds = encodeFeatureBounds;
    }

    public boolean isEncodeFeatureBounds() {
        return this.encodeFeatureBounds;
    }

    public void setEncodeFeatureCollectionBounds(boolean encodeFeatureCollectionBounds) {
        this.encodeFeatureCollectionBounds = encodeFeatureCollectionBounds;
    }

    public boolean isEncodeFeatureCollectionBounds() {
        return this.encodeFeatureCollectionBounds;
    }

    public void setEncodeFeatureCRS(boolean encodeFeatureCRS) {
        this.encodeFeatureCRS = encodeFeatureCRS;
    }

    public boolean isEncodeFeatureCRS() {
        return this.encodeFeatureCRS;
    }

    public void setEncodeFeatureCollectionCRS(boolean encodeFeatureCollectionCRS) {
        this.encodeFeatureCollectionCRS = encodeFeatureCollectionCRS;
    }

    public boolean isEncodeFeatureCollectionCRS() {
        return this.encodeFeatureCollectionCRS;
    }

    public void writeFeature(SimpleFeature feature, Object output) throws IOException {
        GeoJSONUtil.encode(new FeatureEncoder(feature).toJSONString(), output);
    }

    public String toString(SimpleFeature feature) throws IOException {
        StringWriter w = new StringWriter();
        this.writeFeature(feature, w);
        return w.toString();
    }

    public SimpleFeature readFeature(Object input) throws IOException {
        return GeoJSONUtil.parse(new FeatureHandler(this.featureType != null ? new SimpleFeatureBuilder(this.featureType) : null, this.attio), input, false);
    }

    public void writeFeatureCollection(FeatureCollection features, Object output) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "FeatureCollection");
        if (this.encodeFeatureCollectionBounds || this.encodeFeatureCollectionCRS) {
            final ReferencedEnvelope bounds = features.getBounds();
            if (this.encodeFeatureCollectionBounds) {
                obj.put("bbox", new JSONStreamAware(){

                    public void writeJSONString(Writer out) throws IOException {
                        JSONArray.writeJSONString(Arrays.asList(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()), (Writer)out);
                    }
                });
            }
            if (this.encodeFeatureCollectionCRS) {
                obj.put("crs", this.createCRS(bounds.getCoordinateReferenceSystem()));
            }
        }
        obj.put("features", new FeatureCollectionEncoder(features, this.gjson));
        GeoJSONUtil.encode(obj, output);
    }

    public FeatureCollection readFeatureCollection(Object input) throws IOException {
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, null);
        FeatureCollectionIterator it = (FeatureCollectionIterator)this.streamFeatureCollection(input);
        while (it.hasNext()) {
            features.add(it.next());
        }
        return features;
    }

    public FeatureIterator<SimpleFeature> streamFeatureCollection(Object input) throws IOException {
        return new FeatureCollectionIterator(input);
    }

    public String toString(FeatureCollection features) throws IOException {
        StringWriter w = new StringWriter();
        this.writeFeatureCollection(features, w);
        return w.toString();
    }

    public void writeCRS(CoordinateReferenceSystem crs, Object output) throws IOException {
        GeoJSONUtil.encode(this.createCRS(crs), output);
    }

    Map<String, Object> createCRS(CoordinateReferenceSystem crs) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "name");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        try {
            props.put("name", CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true));
        }
        catch (FactoryException e) {
            throw (IOException)new IOException("Error looking up crs identifier").initCause(e);
        }
        obj.put("properties", props);
        return obj;
    }

    public CoordinateReferenceSystem readCRS(Object input) throws IOException {
        return GeoJSONUtil.parse(new CRSHandler(), input, false);
    }

    public String toString(CoordinateReferenceSystem crs) throws IOException {
        StringWriter writer = new StringWriter();
        this.writeCRS(crs, writer);
        return writer.toString();
    }

    class FeatureCollectionEncoder
    implements JSONStreamAware {
        FeatureCollection features;
        GeometryJSON gjson;

        public FeatureCollectionEncoder(FeatureCollection features, GeometryJSON gjson) {
            this.features = features;
            this.gjson = gjson;
        }

        public void writeJSONString(Writer out) throws IOException {
            FeatureEncoder featureEncoder = new FeatureEncoder((SimpleFeatureType)this.features.getSchema());
            out.write("[");
            FeatureIterator i = this.features.features();
            try {
                if (i.hasNext()) {
                    SimpleFeature f = (SimpleFeature)i.next();
                    out.write(featureEncoder.toJSONString(f));
                    while (i.hasNext()) {
                        out.write(",");
                        f = (SimpleFeature)i.next();
                        out.write(featureEncoder.toJSONString(f));
                    }
                }
            }
            finally {
                this.features.close(i);
            }
            out.write("]");
            out.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FeatureCollectionIterator
    implements FeatureIterator<SimpleFeature> {
        Reader reader;
        IFeatureCollectionHandler handler;
        JSONParser parser;
        SimpleFeature next;

        FeatureCollectionIterator(Object input) {
            try {
                this.reader = GeoJSONUtil.toReader(input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.parser = new JSONParser();
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.handler == null) {
                this.handler = new FeatureCollectionHandler(FeatureJSON.this.featureType, FeatureJSON.this.attio);
            }
            this.next = this.readNext();
            return this.next != null;
        }

        public SimpleFeature next() {
            SimpleFeature feature = this.next;
            this.next = null;
            return feature;
        }

        SimpleFeature readNext() {
            try {
                this.parser.parse(this.reader, (ContentHandler)this.handler, true);
                return (SimpleFeature)this.handler.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.reader = null;
            this.parser = null;
            this.handler = null;
        }
    }

    class FeatureEncoder
    implements JSONAware {
        SimpleFeatureType featureType;
        SimpleFeature feature;

        public FeatureEncoder(SimpleFeature feature) {
            this(feature.getType());
            this.feature = feature;
        }

        public FeatureEncoder(SimpleFeatureType featureType) {
            this.featureType = featureType;
        }

        public String toJSONString(SimpleFeature feature) {
            CoordinateReferenceSystem crs;
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            GeoJSONUtil.entry("type", "Feature", sb);
            sb.append(",");
            if (FeatureJSON.this.encodeFeatureCRS && (crs = feature.getFeatureType().getCoordinateReferenceSystem()) != null) {
                try {
                    GeoJSONUtil.string("crs", sb).append(":");
                    sb.append(FeatureJSON.this.toString(crs)).append(",");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (FeatureJSON.this.encodeFeatureBounds) {
                BoundingBox bbox = feature.getBounds();
                GeoJSONUtil.string("bbox", sb).append(":");
                sb.append(FeatureJSON.this.gjson.toString(bbox)).append(",");
            }
            if (feature.getDefaultGeometry() != null) {
                GeoJSONUtil.string("geometry", sb).append(":").append(FeatureJSON.this.gjson.toString((Geometry)feature.getDefaultGeometry()));
                sb.append(",");
            }
            int gindex = this.featureType.getGeometryDescriptor() != null ? this.featureType.indexOf(this.featureType.getGeometryDescriptor().getLocalName()) : -1;
            GeoJSONUtil.string("properties", sb).append(":").append("{");
            boolean attributesWritten = false;
            int i = 0;
            while (i < this.featureType.getAttributeCount()) {
                Object value;
                AttributeDescriptor ad = this.featureType.getDescriptor(i);
                if (i != gindex && (value = feature.getAttribute(i)) != null) {
                    attributesWritten = true;
                    if (value instanceof Envelope) {
                        GeoJSONUtil.array(ad.getLocalName(), FeatureJSON.this.gjson.toString((Envelope)value), sb);
                    } else if (value instanceof BoundingBox) {
                        GeoJSONUtil.array(ad.getLocalName(), FeatureJSON.this.gjson.toString((BoundingBox)value), sb);
                    } else if (value instanceof Geometry) {
                        GeoJSONUtil.string(ad.getLocalName(), sb).append(":").append(FeatureJSON.this.gjson.toString((Geometry)value));
                    } else {
                        GeoJSONUtil.entry(ad.getLocalName(), value, sb);
                    }
                    sb.append(",");
                }
                ++i;
            }
            if (attributesWritten) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("},");
            GeoJSONUtil.entry("id", feature.getID(), sb);
            sb.append("}");
            return sb.toString();
        }

        public String toJSONString() {
            return this.toJSONString(this.feature);
        }
    }
}

