/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geojson.GeoJSONUtil;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.geom.GeometryCollectionHandler;
import org.geotools.geojson.geom.GeometryHandler;
import org.geotools.geojson.geom.LineHandler;
import org.geotools.geojson.geom.MultiLineHandler;
import org.geotools.geojson.geom.MultiPointHandler;
import org.geotools.geojson.geom.MultiPolygonHandler;
import org.geotools.geojson.geom.PointHandler;
import org.geotools.geojson.geom.PolygonHandler;
import org.json.simple.JSONAware;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryJSON {
    GeometryFactory factory = new GeometryFactory();
    boolean trace = false;
    int decimals;
    double scale;

    public GeometryJSON() {
        this(4);
    }

    public GeometryJSON(int decimals) {
        this.decimals = decimals;
        this.scale = Math.pow(10.0, decimals);
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void write(Geometry geometry, Object output) throws IOException {
        GeoJSONUtil.encode(this.create(geometry), output);
    }

    public String toString(Geometry geometry) {
        StringWriter w = new StringWriter();
        try {
            this.write(geometry, w);
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, Object> create(Geometry geometry) {
        if (geometry instanceof Point) {
            return this.createPoint((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.createLine((LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.createPolygon((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.createMultiPoint((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.createMultiLine((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.createMultiPolygon((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.createGeometryCollection((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unable to encode object " + geometry);
    }

    public Geometry read(Object input) throws IOException {
        return this.parse(new GeometryHandler(this.factory), input);
    }

    public void writePoint(Point point, Object output) throws IOException {
        this.encode(this.createPoint(point), output);
    }

    Map<String, Object> createPoint(Point point) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "Point");
        obj.put("coordinates", new CoordinateSequenceEncoder(point.getCoordinateSequence(), this.scale));
        return obj;
    }

    public Point readPoint(Object input) throws IOException {
        return this.parse(new PointHandler(this.factory), input);
    }

    public void writeLine(LineString line, Object output) throws IOException {
        this.encode(this.createLine(line), output);
    }

    Map<String, Object> createLine(LineString line) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "LineString");
        obj.put("coordinates", new CoordinateSequenceEncoder(line.getCoordinateSequence(), this.scale));
        return obj;
    }

    public LineString readLine(Object input) throws IOException {
        return this.parse(new LineHandler(this.factory), input);
    }

    public void writePolygon(Polygon poly, Object output) throws IOException {
        this.encode(this.createPolygon(poly), output);
    }

    Map<String, Object> createPolygon(Polygon poly) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "Polygon");
        obj.put("coordinates", this.toList(poly));
        return obj;
    }

    public Polygon readPolygon(Object input) throws IOException {
        return this.parse(new PolygonHandler(this.factory), input);
    }

    public void writeMultiPoint(MultiPoint mpoint, Object output) throws IOException {
        this.encode(this.createMultiPoint(mpoint), output);
    }

    Map<String, Object> createMultiPoint(MultiPoint mpoint) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "MultiPoint");
        obj.put("coordinates", this.toList((GeometryCollection)mpoint));
        return obj;
    }

    public MultiPoint readMultiPoint(Object input) throws IOException {
        return this.parse(new MultiPointHandler(this.factory), input);
    }

    public void writeMultiLine(MultiLineString mline, Object output) throws IOException {
        this.encode(this.createMultiLine(mline), output);
    }

    Map<String, Object> createMultiLine(MultiLineString mline) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "MultiLineString");
        obj.put("coordinates", this.toList((GeometryCollection)mline));
        return obj;
    }

    public MultiLineString readMultiLine(Object input) throws IOException {
        return this.parse(new MultiLineHandler(this.factory), input);
    }

    public void writeMultiPolygon(MultiPolygon mpoly, Object output) throws IOException {
        this.encode(this.createMultiPolygon(mpoly), output);
    }

    Map<String, Object> createMultiPolygon(MultiPolygon mpoly) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("type", "MultiPolygon");
        obj.put("coordinates", this.toList((GeometryCollection)mpoly));
        return obj;
    }

    public MultiPolygon readMultiPolygon(Object input) throws IOException {
        return this.parse(new MultiPolygonHandler(this.factory), input);
    }

    public void writeGeometryCollection(GeometryCollection gcol, Object output) throws IOException {
        this.encode(this.createGeometryCollection(gcol), output);
    }

    Map<String, Object> createGeometryCollection(GeometryCollection gcol) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> geoms = new ArrayList<Map<String, Object>>(gcol.getNumGeometries());
        int i = 0;
        while (i < gcol.getNumGeometries()) {
            geoms.add(this.create(gcol.getGeometryN(i)));
            ++i;
        }
        obj.put("type", "GeometryCollection");
        obj.put("geometries", geoms);
        return obj;
    }

    public GeometryCollection readGeometryCollection(Object input) throws IOException {
        return this.parse(new GeometryCollectionHandler(this.factory), input);
    }

    public String toString(BoundingBox bbox) {
        return new StringBuffer().append("[").append(bbox.getMinX()).append(",").append(bbox.getMinY()).append(",").append(bbox.getMaxX()).append(",").append(bbox.getMaxY()).append("]").toString();
    }

    public String toString(Envelope e) {
        return new StringBuffer().append("[").append(e.getMinX()).append(",").append(e.getMinY()).append(",").append(e.getMaxX()).append(",").append(e.getMaxY()).append("]").toString();
    }

    <G extends Geometry> G parse(IContentHandler<G> handler, Object input) throws IOException {
        return (G)((Geometry)GeoJSONUtil.parse(handler, input, this.trace));
    }

    void encode(Map<String, Object> obj, Object output) throws IOException {
        GeoJSONUtil.encode(obj, output);
    }

    List toList(Polygon poly) {
        ArrayList<CoordinateSequenceEncoder> list = new ArrayList<CoordinateSequenceEncoder>();
        list.add(new CoordinateSequenceEncoder(poly.getExteriorRing().getCoordinateSequence(), this.scale));
        int i = 0;
        while (i < poly.getNumInteriorRing()) {
            list.add(new CoordinateSequenceEncoder(poly.getInteriorRingN(i).getCoordinateSequence(), this.scale));
            ++i;
        }
        return list;
    }

    List toList(GeometryCollection mgeom) {
        ArrayList<Object> list = new ArrayList<Object>(mgeom.getNumGeometries());
        int i = 0;
        while (i < mgeom.getNumGeometries()) {
            Geometry g = mgeom.getGeometryN(i);
            if (g instanceof Polygon) {
                list.add(this.toList((Polygon)g));
            } else if (g instanceof LineString) {
                list.add(new CoordinateSequenceEncoder(((LineString)g).getCoordinateSequence(), this.scale));
            } else if (g instanceof Point) {
                list.add(new CoordinateSequenceEncoder(((Point)g).getCoordinateSequence(), this.scale));
            }
            ++i;
        }
        return list;
    }

    static class CoordinateSequenceEncoder
    implements JSONAware {
        private static final double DECIMAL_MIN = Math.pow(10.0, -3.0);
        private static final double DECIMAL_MAX = Math.pow(10.0, 7.0);
        CoordinateSequence seq;
        double scale;

        CoordinateSequenceEncoder(CoordinateSequence seq, double scale) {
            this.seq = seq;
            this.scale = scale;
        }

        public String toJSONString() {
            int size = this.seq.size();
            StringBuilder sb = new StringBuilder();
            if (size > 1) {
                sb.append("[");
            }
            int i = 0;
            while (i < this.seq.size()) {
                sb.append("[");
                this.formatDecimal(this.seq.getX(i), sb);
                sb.append(",");
                this.formatDecimal(this.seq.getY(i), sb);
                sb.append("],");
                ++i;
            }
            sb.setLength(sb.length() - 1);
            if (size > 1) {
                sb.append("]");
            }
            return sb.toString();
        }

        public void writeJSONString(Writer out) throws IOException {
            int size = this.seq.size();
            if (size > 1) {
                out.write("[");
            }
            int i = 0;
            while (i < this.seq.size()) {
                out.write("[");
                out.write(String.valueOf(this.seq.getX(i)));
                out.write(",");
                out.write(String.valueOf(this.seq.getY(i)));
                out.write("]");
                if (i < this.seq.size() - 1) {
                    out.write(",");
                }
                ++i;
            }
            if (size > 1) {
                out.write("]");
            }
        }

        private void formatDecimal(double x, StringBuilder sb) {
            if (Math.abs(x) >= DECIMAL_MIN && x < DECIMAL_MAX) {
                long lx = (long)(x = Math.floor(x * this.scale + 0.5) / this.scale);
                if ((double)lx == x) {
                    sb.append(lx);
                } else {
                    sb.append(x);
                }
            } else {
                sb.append(x);
            }
        }
    }
}

