/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geojson.geom.GeometryHandlerBase;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonHandler
extends GeometryHandlerBase<Polygon> {
    List<Coordinate> coordinates;
    List<Coordinate[]> rings;

    public PolygonHandler(GeometryFactory factory) {
        super(factory);
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("coordinates".equals(key)) {
            this.rings = new ArrayList<Coordinate[]>();
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.rings != null) {
            if (this.rings.isEmpty()) {
                throw new IllegalArgumentException("Polygon specified with no rings.");
            }
            LinearRing outer = this.factory.createLinearRing(this.rings.get(0));
            LinearRing[] inner = null;
            if (this.rings.size() > 1) {
                inner = new LinearRing[this.rings.size() - 1];
                int i = 1;
                while (i < this.rings.size()) {
                    inner[i - 1] = this.factory.createLinearRing(this.rings.get(i));
                    ++i;
                }
            }
            this.value = this.factory.createPolygon(outer, inner);
            this.rings = null;
        }
        return true;
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<Coordinate>();
        } else if (this.ordinates == null) {
            this.ordinates = new ArrayList();
        }
        return true;
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        if (this.ordinates != null) {
            Coordinate c = this.coordinate(this.ordinates);
            this.coordinates.add(c);
            this.ordinates = null;
        } else if (this.coordinates != null) {
            this.rings.add(this.coordinates(this.coordinates));
            this.coordinates = null;
        }
        return true;
    }
}

