/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.EdgeEnd;
import org.geotools.geometry.iso.topograph2D.GeometryGraph;
import org.geotools.geometry.iso.topograph2D.IntersectionMatrix;
import org.geotools.geometry.iso.topograph2D.Label;

public class EdgeEndBundle
extends EdgeEnd {
    private List edgeEnds = new ArrayList();

    public EdgeEndBundle(EdgeEnd e) {
        super(e.getEdge(), e.getCoordinate(), e.getDirectedCoordinate(), new Label(e.getLabel()));
        this.insert(e);
    }

    public Label getLabel() {
        return this.label;
    }

    public Iterator iterator() {
        return this.edgeEnds.iterator();
    }

    public List getEdgeEnds() {
        return this.edgeEnds;
    }

    public void insert(EdgeEnd e) {
        this.edgeEnds.add(e);
    }

    public void computeLabel() {
        boolean isArea = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = (EdgeEnd)it.next();
            if (!e.getLabel().isArea()) continue;
            isArea = true;
        }
        this.label = isArea ? new Label(-1, -1, -1) : new Label(-1);
        for (int i = 0; i < 2; ++i) {
            this.computeLabelOn(i);
            if (!isArea) continue;
            this.computeLabelSides(i);
        }
    }

    private void computeLabelOn(int geomIndex) {
        int boundaryCount = 0;
        boolean foundInterior = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = (EdgeEnd)it.next();
            int loc = e.getLabel().getLocation(geomIndex);
            if (loc == 1) {
                ++boundaryCount;
            }
            if (loc != 0) continue;
            foundInterior = true;
        }
        int loc = -1;
        if (foundInterior) {
            loc = 0;
        }
        if (boundaryCount > 0) {
            loc = GeometryGraph.determineBoundary(boundaryCount);
        }
        this.label.setLocation(geomIndex, loc);
    }

    private void computeLabelSides(int geomIndex) {
        this.computeLabelSide(geomIndex, 1);
        this.computeLabelSide(geomIndex, 2);
    }

    private void computeLabelSide(int geomIndex, int side) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = (EdgeEnd)it.next();
            if (!e.getLabel().isArea()) continue;
            int loc = e.getLabel().getLocation(geomIndex, side);
            if (loc == 0) {
                this.label.setLocation(geomIndex, side, 0);
                return;
            }
            if (loc != 2) continue;
            this.label.setLocation(geomIndex, side, 2);
        }
    }

    void updateIM(IntersectionMatrix im) {
        Edge.updateIM(this.label, im);
    }
}

