/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.geotools.geometry.iso.util.algorithmND.AlgoPointND;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LineSegmentImpl
extends LineStringImpl
implements LineSegment {
    public LineSegmentImpl(PointArrayImpl pointArray, double startPar) {
        super(pointArray, startPar);
        if (pointArray.length() != 2) {
            throw new IllegalArgumentException("A line segement must have exact two positions");
        }
    }

    public LineSegmentImpl(LineSegmentImpl other) {
        super(other);
    }

    public LineSegmentImpl(CoordinateReferenceSystem crs, double[] from, double[] to, double startParam) {
        this(new PointArrayImpl(new DirectPositionImpl(crs, from), new DirectPositionImpl(crs, to)), startParam);
    }

    public LineSegmentImpl(DirectPosition one, DirectPosition two, double startParam) {
        this(new PointArrayImpl(one, two), startParam);
    }

    public boolean isSimple() {
        return true;
    }

    public DirectPosition forParamInSegment(double dist) {
        if (dist < this.startParam || dist > this.endParam) {
            return null;
        }
        double par = DoubleOperation.div(DoubleOperation.subtract(dist, this.startParam), this.length());
        return LineSegmentImpl.linearInterpolate(this.getStartPoint(), this.getEndPoint(), par);
    }

    public static DirectPositionImpl linearInterpolate(DirectPosition p0, DirectPosition p1, double par) {
        double[] coord = AlgoPointND.evaluate(p0.getCoordinates(), p1.getCoordinates(), par);
        return new DirectPositionImpl(p0.getCoordinateReferenceSystem(), coord);
    }

    public double[] getTangentInSegment(double distance) {
        double[] startpoint = this.getStartPoint().getCoordinates();
        double[] endpoint = this.getEndPoint().getCoordinates();
        double[] newEndPoint = AlgoPointND.subtract(startpoint, endpoint);
        newEndPoint = AlgoPointND.normalize(newEndPoint);
        double[] posAtDistance = this.forParamInSegment(distance).getCoordinates();
        newEndPoint = AlgoPointND.add(newEndPoint, posAtDistance);
        return newEndPoint;
    }
}

