/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation.relate;

import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.operation.relate.EdgeEndBuilder;
import org.geotools.geometry.iso.operation.relate.RelateNode;
import org.geotools.geometry.iso.operation.relate.RelateNodeFactory;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.EdgeEnd;
import org.geotools.geometry.iso.topograph2D.EdgeIntersection;
import org.geotools.geometry.iso.topograph2D.GeometryGraph;
import org.geotools.geometry.iso.topograph2D.Node;
import org.geotools.geometry.iso.topograph2D.NodeMap;

public class RelateNodeGraph {
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public void build(GeometryGraph geomGraph) {
        this.computeIntersectionNodes(geomGraph, 0);
        this.copyNodesAndLabels(geomGraph, 0);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List eeList = eeBuilder.computeEdgeEnds(geomGraph.getEdgeIterator());
        this.insertEdgeEnds(eeList);
    }

    public void computeIntersectionNodes(GeometryGraph geomGraph, int argIndex) {
        Iterator edgeIt = geomGraph.getEdgeIterator();
        while (edgeIt.hasNext()) {
            Edge e = (Edge)edgeIt.next();
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                RelateNode n = (RelateNode)this.nodes.addNode(ei.coord);
                if (eLoc == 1) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n.getLabel().isNull(argIndex)) continue;
                n.setLabel(argIndex, 0);
            }
        }
    }

    public void copyNodesAndLabels(GeometryGraph geomGraph, int argIndex) {
        Iterator nodeIt = geomGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            Node graphNode = (Node)nodeIt.next();
            Node newNode = this.nodes.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    public void insertEdgeEnds(List ee) {
        for (EdgeEnd e : ee) {
            this.nodes.add(e);
        }
    }
}

