/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.opt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.DirectedEdge;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.opt.OptGraphable;

public class OptDirectedNode
extends OptGraphable
implements DirectedNode {
    private transient DirectedEdge[] m_in;
    private transient DirectedEdge[] m_out;

    public OptDirectedNode() {
        this(0, 0);
    }

    public OptDirectedNode(int indegree, int outdegree) {
        this.m_in = new DirectedEdge[indegree];
        this.m_out = new DirectedEdge[outdegree];
    }

    public void add(Edge e) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#add(Edge)");
    }

    public void addIn(DirectedEdge e) {
        for (int i = 0; i < this.m_in.length; ++i) {
            if (this.m_in[i] != null) continue;
            this.m_in[i] = e;
            return;
        }
    }

    public void addOut(DirectedEdge e) {
        for (int i = 0; i < this.m_out.length; ++i) {
            if (this.m_out[i] != null) continue;
            this.m_out[i] = e;
            return;
        }
    }

    public void remove(Edge e) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#remove(Edge)");
    }

    public void removeIn(DirectedEdge e) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#removeIn(DirectedEdge)");
    }

    public void removeOut(DirectedEdge e) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#removeOut(DirectedEdge)");
    }

    public Edge getEdge(Node other) {
        Edge e = this.getInEdge((DirectedNode)other);
        if (e == null) {
            e = this.getOutEdge((DirectedNode)other);
        }
        return e;
    }

    public Edge getInEdge(DirectedNode other) {
        for (int i = 0; i < this.m_in.length; ++i) {
            if (!this.m_in[i].getInNode().equals(other)) continue;
            return this.m_in[i];
        }
        return null;
    }

    public Edge getOutEdge(DirectedNode other) {
        ArrayList edges = new ArrayList();
        for (int i = 0; i < this.m_out.length; ++i) {
            if (!this.m_out[i].getOutNode().equals(other)) continue;
            return this.m_out[i];
        }
        return null;
    }

    public List getEdges(Node other) {
        List l = this.getInEdges((DirectedNode)other);
        l.addAll(this.getOutEdges((DirectedNode)other));
        return l;
    }

    public List getInEdges(DirectedNode other) {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (int i = 0; i < this.m_in.length; ++i) {
            if (!this.m_in[i].getInNode().equals(other)) continue;
            edges.add(this.m_in[i]);
        }
        return edges;
    }

    public List getOutEdges(DirectedNode other) {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (int i = 0; i < this.m_out.length; ++i) {
            if (!this.m_out[i].getOutNode().equals(other)) continue;
            edges.add(this.m_out[i]);
        }
        return edges;
    }

    public List getEdges() {
        int i;
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (i = 0; i < this.m_in.length; ++i) {
            edges.add(this.m_in[i]);
        }
        for (i = 0; i < this.m_out.length; ++i) {
            edges.add(this.m_out[i]);
        }
        return edges;
    }

    public DirectedEdge[] getInEdgeArray() {
        return this.m_in;
    }

    public List getInEdges() {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (int i = 0; i < this.m_in.length; ++i) {
            edges.add(this.m_in[i]);
        }
        return edges;
    }

    public DirectedEdge[] getOutEdgeArray() {
        return this.m_out;
    }

    public List getOutEdges() {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (int i = 0; i < this.m_out.length; ++i) {
            edges.add(this.m_out[i]);
        }
        return edges;
    }

    public int getDegree() {
        return this.m_in.length + this.m_out.length;
    }

    public void setInDegree(int indegree) {
        this.m_in = new DirectedEdge[indegree];
    }

    public int getInDegree() {
        return this.m_in.length;
    }

    public void setOutDegree(int outdegree) {
        this.m_out = new DirectedEdge[outdegree];
    }

    public int getOutDegree() {
        return this.m_out.length;
    }

    public Iterator getRelated() {
        return new RelatedIterator(2);
    }

    public Iterator getInRelated() {
        return new RelatedIterator(0);
    }

    public Iterator getOutRelated() {
        return new RelatedIterator(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setInDegree(in.readInt());
        this.setOutDegree(in.readInt());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getInDegree());
        out.writeInt(this.getOutDegree());
    }

    public class RelatedIterator
    implements Iterator {
        public static final int IN = 0;
        public static final int OUT = 1;
        public static final int BOTH = 2;
        private int m_mode;
        private int m_index;

        public RelatedIterator(int mode) {
            this.m_mode = mode;
            this.m_index = 0;
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + "#remove()");
        }

        public boolean hasNext() {
            switch (this.m_mode) {
                case 0: {
                    return this.m_index < OptDirectedNode.this.m_in.length;
                }
                case 1: {
                    return this.m_index < OptDirectedNode.this.m_out.length;
                }
                case 2: {
                    return this.m_index < OptDirectedNode.this.m_in.length + OptDirectedNode.this.m_out.length;
                }
            }
            return false;
        }

        public Object next() {
            switch (this.m_mode) {
                case 0: {
                    return OptDirectedNode.this.m_in[this.m_index++].getInNode();
                }
                case 1: {
                    return OptDirectedNode.this.m_out[this.m_index++].getOutNode();
                }
                case 2: {
                    return this.m_index < OptDirectedNode.this.m_in.length ? OptDirectedNode.this.m_in[this.m_index++].getInNode() : OptDirectedNode.this.m_out[this.m_index++ - OptDirectedNode.this.m_in.length].getOutNode();
                }
            }
            return null;
        }
    }
}

