/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.line;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.HashMap;
import java.util.Map;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.build.basic.BasicGraphBuilder;
import org.geotools.graph.build.line.LineGraphGenerator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;

public class BasicLineGraphGenerator
implements LineGraphGenerator {
    private HashMap m_coord2node = new HashMap();
    private GraphBuilder m_builder;

    public BasicLineGraphGenerator() {
        this.setGraphBuilder(new BasicGraphBuilder());
    }

    public Graphable add(Object obj) {
        Node n2;
        LineSegment line = (LineSegment)obj;
        Coordinate c = line.p0;
        Node n1 = (Node)this.m_coord2node.get(c);
        if (n1 == null) {
            n1 = this.getGraphBuilder().buildNode();
            this.setObject(n1, (Object)c);
            this.getGraphBuilder().addNode(n1);
            this.m_coord2node.put(c, n1);
        }
        if ((n2 = (Node)this.m_coord2node.get(c = line.p1)) == null) {
            n2 = this.getGraphBuilder().buildNode();
            this.setObject(n2, (Object)c);
            this.getGraphBuilder().addNode(n2);
            this.m_coord2node.put(c, n2);
        }
        Edge e = this.getGraphBuilder().buildEdge(n1, n2);
        this.setObject(e, (Object)line);
        this.getGraphBuilder().addEdge(e);
        return e;
    }

    public Graphable get(Object obj) {
        LineSegment line = (LineSegment)obj;
        Node n1 = (Node)this.m_coord2node.get(line.p0);
        Node n2 = (Node)this.m_coord2node.get(line.p1);
        if (n1 == null || n2 == null) {
            return null;
        }
        return n1.getEdge(n2);
    }

    public Graphable remove(Object obj) {
        LineSegment line = (LineSegment)obj;
        Node n1 = (Node)this.m_coord2node.get(line.p0);
        Node n2 = (Node)this.m_coord2node.get(line.p1);
        if (n1 == null || n2 == null) {
            return null;
        }
        Edge e = n1.getEdge(n2);
        this.getGraphBuilder().removeEdge(e);
        return e;
    }

    public void setGraphBuilder(GraphBuilder builder) {
        this.m_builder = builder;
    }

    public GraphBuilder getGraphBuilder() {
        return this.m_builder;
    }

    public Graph getGraph() {
        return this.getGraphBuilder().getGraph();
    }

    public Map getNodeMap() {
        return this.m_coord2node;
    }

    public Node getNode(Coordinate c) {
        return (Node)this.m_coord2node.get(c);
    }

    public Edge getEdge(Coordinate c1, Coordinate c2) {
        Node n1 = (Node)this.m_coord2node.get(c1);
        Node n2 = (Node)this.m_coord2node.get(c2);
        return n1.getEdge(n2);
    }

    protected void setObject(Edge e, Object obj) {
        e.setObject(obj);
    }

    protected void setObject(Node n, Object obj) {
        n.setObject(obj);
    }
}

