/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.hexagon;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.AbstractGridBuilder;
import org.geotools.grid.GridElement;
import org.geotools.grid.Neighbor;
import org.geotools.grid.Orientation;
import org.geotools.grid.hexagon.Hexagon;
import org.geotools.grid.hexagon.Hexagons;

class HexagonGridBuilder
extends AbstractGridBuilder {
    private final double sideLen;
    private final Orientation orientation;
    private final Neighbor[] nextX = new Neighbor[2];
    private final Neighbor[] nextY = new Neighbor[2];
    private int xIndex = 0;
    private int yIndex = 0;

    public HexagonGridBuilder(ReferencedEnvelope gridBounds, double sideLen, Orientation orientation) {
        super(gridBounds);
        this.sideLen = sideLen;
        this.orientation = orientation;
        if (orientation == Orientation.ANGLED) {
            this.nextX[0] = this.nextX[1] = Neighbor.RIGHT;
            this.nextY[0] = Neighbor.UPPER_RIGHT;
            this.nextY[1] = Neighbor.UPPER_LEFT;
        } else {
            this.nextX[0] = Neighbor.LOWER_RIGHT;
            this.nextX[1] = Neighbor.UPPER_RIGHT;
            this.nextY[0] = this.nextY[1] = Neighbor.UPPER;
        }
    }

    public boolean isValidNeighbor(Neighbor neighbor) {
        switch (neighbor) {
            case LEFT: 
            case RIGHT: {
                return this.orientation == Orientation.ANGLED;
            }
            case LOWER: 
            case UPPER: {
                return this.orientation == Orientation.FLAT;
            }
            case LOWER_LEFT: 
            case LOWER_RIGHT: 
            case UPPER_LEFT: 
            case UPPER_RIGHT: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid value for neighbor");
    }

    public Hexagon createNeighbor(GridElement el, Neighbor neighbor) {
        double dy;
        double dx;
        if (el == null || neighbor == null) {
            throw new IllegalArgumentException("el and neighbour position must both be non-null");
        }
        if (!(el instanceof Hexagon)) {
            throw new IllegalArgumentException("el must be an instance of Hexagon");
        }
        Hexagon hexagon = (Hexagon)el;
        if (!this.isValidNeighbor(neighbor)) {
            throw new IllegalArgumentException((Object)((Object)neighbor) + " is not a valid neighbour position for orientation " + (Object)((Object)hexagon.getOrientation()));
        }
        ReferencedEnvelope bounds = hexagon.getBounds();
        switch (neighbor) {
            case LEFT: {
                dx = -bounds.getWidth();
                dy = 0.0;
                break;
            }
            case LOWER: {
                dx = 0.0;
                dy = -bounds.getHeight();
                break;
            }
            case LOWER_LEFT: {
                if (hexagon.getOrientation() == Orientation.FLAT) {
                    dx = -0.75 * bounds.getWidth();
                    dy = -0.5 * bounds.getHeight();
                    break;
                }
                dx = -0.5 * bounds.getWidth();
                dy = -0.75 * bounds.getHeight();
                break;
            }
            case LOWER_RIGHT: {
                if (hexagon.getOrientation() == Orientation.FLAT) {
                    dx = 0.75 * bounds.getWidth();
                    dy = -0.5 * bounds.getHeight();
                    break;
                }
                dx = 0.5 * bounds.getWidth();
                dy = -0.75 * bounds.getHeight();
                break;
            }
            case RIGHT: {
                dx = bounds.getWidth();
                dy = 0.0;
                break;
            }
            case UPPER: {
                dx = 0.0;
                dy = bounds.getHeight();
                break;
            }
            case UPPER_LEFT: {
                if (hexagon.getOrientation() == Orientation.FLAT) {
                    dx = -0.75 * bounds.getWidth();
                    dy = 0.5 * bounds.getHeight();
                    break;
                }
                dx = -0.5 * bounds.getWidth();
                dy = 0.75 * bounds.getHeight();
                break;
            }
            case UPPER_RIGHT: {
                if (hexagon.getOrientation() == Orientation.FLAT) {
                    dx = 0.75 * bounds.getWidth();
                    dy = 0.5 * bounds.getHeight();
                    break;
                }
                dx = 0.5 * bounds.getWidth();
                dy = 0.75 * bounds.getHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized value for neighbor");
            }
        }
        return Hexagons.create(bounds.getMinX() + dx, bounds.getMinY() + dy, hexagon.getSideLength(), hexagon.getOrientation(), bounds.getCoordinateReferenceSystem());
    }

    public GridElement getFirstElement() {
        return Hexagons.create(this.gridBounds.getMinX(), this.gridBounds.getMinY(), this.sideLen, this.orientation, this.gridBounds.getCoordinateReferenceSystem());
    }

    public GridElement getNextXElement(GridElement el) {
        Hexagon h = this.createNeighbor(el, this.nextX[this.xIndex]);
        this.xIndex = (this.xIndex + 1) % 2;
        return h;
    }

    public GridElement getNextYElement(GridElement el) {
        Hexagon h = this.createNeighbor(el, this.nextY[this.yIndex]);
        this.yIndex = (this.yIndex + 1) % 2;
        this.xIndex = 0;
        return h;
    }

    public boolean isValidDenseVertexSpacing(double v) {
        return v > 0.0 && v < this.sideLen / 2.0;
    }
}

