/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverageWriter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.gtopo30.GTopo30Format;
import org.geotools.gce.gtopo30.GTopo30WriteParams;
import org.geotools.gce.gtopo30.NoDataReplacerOpImage;
import org.geotools.image.io.ImageIOExt;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public final class GTopo30Writer
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.gtopo30");
    private static final SelectSampleDimension sdFactory;
    private static final Resample resampleFactory;
    private static final int GIF_WIDTH = 640;
    private static final int GIF_HEIGHT = 480;

    public GTopo30Writer(Object dest) throws DataSourceException {
        this(dest, null);
    }

    public GTopo30Writer(Object dest, Hints hints) throws DataSourceException {
        if (dest == null) {
            throw new NullPointerException("The provided destination is null.");
        }
        this.destination = dest;
        if (dest instanceof String) {
            File temp = new File((String)dest);
            if (temp.exists() && !temp.isDirectory() || !temp.exists()) {
                this.destination = null;
            } else if (!temp.exists()) {
                this.destination = !temp.mkdir() ? null : temp.getAbsolutePath();
            }
        } else if (dest instanceof File) {
            File temp = (File)dest;
            if (temp.exists() && !temp.isDirectory()) {
                this.destination = null;
            } else if (!temp.exists()) {
                this.destination = temp.mkdir() ? temp.getAbsolutePath() : null;
            }
        } else if (dest instanceof URL) {
            File temp;
            URL url = (URL)dest;
            if (url.getProtocol().compareToIgnoreCase("file") != 0) {
                this.destination = null;
            }
            if ((temp = DataUtilities.urlToFile((URL)url)).exists() && !temp.isDirectory()) {
                this.destination = null;
            } else if (!temp.exists()) {
                this.destination = temp.mkdir() ? temp.getAbsolutePath() : null;
            }
        } else if (dest instanceof ImageOutputStream) {
            this.destination = dest;
        } else {
            throw new IllegalArgumentException("The provided destination is of an incorrect type.");
        }
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            this.hints.add((RenderingHints)hints);
        }
    }

    public Format getFormat() {
        return new GTopo30Format();
    }

    public void write(GridCoverage coverage, GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        if (coverage == null) {
            throw new NullPointerException("The provided source coverage is null");
        }
        GridCoverage2D gc2D = (GridCoverage2D)coverage;
        GTopo30WriteParams gtParams = null;
        if (params != null && params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                Parameter param = (Parameter)params[i];
                if (!param.getDescriptor().getName().getCode().equals(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString())) continue;
                gtParams = (GeoToolsWriteParams)param.getValue();
            }
        }
        if (gtParams == null) {
            gtParams = new GTopo30WriteParams();
        }
        boolean compressed = gtParams.getCompressionMode() == 2;
        int[] writeBands = gtParams.getSourceBands();
        int writeBand = CoverageUtilities.getVisibleBand((Object)gc2D.getRenderedImage());
        if (!(writeBands != null && writeBands.length != 0 && writeBands.length <= 1 || writeBand >= 0 && writeBand <= gc2D.getNumSampleDimensions())) {
            throw new IllegalArgumentException("You need to supply a valid index for deciding which band to write.");
        }
        if (writeBands != null && writeBands.length != 0 && writeBands.length <= 1) {
            writeBand = writeBands[0];
        }
        String fileName = gc2D.getName().toString();
        if (compressed) {
            this.destination = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File((File)this.destination, new StringBuffer(fileName).append(".zip").toString()))));
        }
        ParameterValueGroup pvg = sdFactory.getParameters();
        pvg.parameter("Source").setValue((Object)gc2D);
        pvg.parameter("SampleDimensions").setValue((Object)new int[]{writeBand});
        pvg.parameter("VisibleSampleDimension").setValue(writeBand);
        gc2D = (GridCoverage2D)sdFactory.doOperation(pvg, this.hints);
        PlanarImage reFormattedData2Short = this.reFormatCoverageImage(gc2D, 2);
        this.writeDEM(reFormattedData2Short, fileName, this.destination);
        this.writeStats(reFormattedData2Short, fileName, this.destination, gc2D);
        this.writeWorldFile(gc2D, fileName, this.destination);
        this.writePRJ(gc2D, fileName, this.destination);
        this.writeHDR(gc2D, fileName, this.destination);
        this.writeGIF(gc2D, fileName, this.destination);
        this.writeSRC(gc2D, fileName, this.destination);
        if (compressed) {
            ((ZipOutputStream)this.destination).close();
        }
    }

    private PlanarImage reFormatCoverageImage(GridCoverage2D gc2D, int writeBand) {
        PlanarImage image = (PlanarImage)gc2D.getRenderedImage();
        int origDataType = image.getSampleModel().getDataType();
        if (2 == origDataType) {
            return image;
        }
        GridSampleDimension visibleSD = gc2D.getSampleDimension(0).geophysics(true);
        List oldCategories = visibleSD.getCategories();
        Category candidate2 = null;
        NumberRange candidateRange = null;
        for (Category candidate2 : oldCategories) {
            if (!candidate2.getName().toString().equalsIgnoreCase("no data")) continue;
            candidateRange = candidate2.getRange();
            break;
        }
        double oldNoData = candidateRange.getMinimum();
        ParameterBlockJAI pbjM = new ParameterBlockJAI("org.geotools.gce.gtopo30.NoDataReplacer");
        pbjM.addSource((Object)image);
        pbjM.setParameter("oldNoData", oldNoData);
        image = JAI.create((String)"org.geotools.gce.gtopo30.NoDataReplacer", (ParameterBlock)pbjM, (RenderingHints)this.hints);
        return image;
    }

    private void writeHDR(GridCoverage2D gc, String name, Object dest) throws IOException {
        double noData = -9999.0;
        AffineTransform gridToWorld = (AffineTransform)gc.getGridGeometry().getGridToCRS2D();
        boolean lonFirst = XAffineTransform.getSwapXY((AffineTransform)gridToWorld) != -1;
        double geospatialDx = Math.abs(lonFirst ? gridToWorld.getScaleX() : gridToWorld.getShearY());
        double geospatialDy = Math.abs(lonFirst ? gridToWorld.getScaleY() : gridToWorld.getShearX());
        double xUpperLeft = lonFirst ? gridToWorld.getTranslateX() : gridToWorld.getTranslateY();
        double yUpperLeft = lonFirst ? gridToWorld.getTranslateY() : gridToWorld.getTranslateX();
        int geometryWidth = gc.getGridGeometry().getGridRange().getSpan(0);
        int geometryHeight = gc.getGridGeometry().getGridRange().getSpan(1);
        if (dest instanceof File) {
            PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File((File)dest, new StringBuffer(name).append(".HDR").toString()))));
            out.print("BYTEORDER");
            out.print(" ");
            out.println("M");
            out.print("LAYOUT");
            out.print(" ");
            out.println("BIL");
            out.print("NROWS");
            out.print(" ");
            out.println(geometryHeight);
            out.print("NCOLS");
            out.print(" ");
            out.println(geometryWidth);
            out.print("NBANDS");
            out.print(" ");
            out.println("1");
            out.print("NBITS");
            out.print(" ");
            out.println("16");
            out.print("BANDROWBYTES");
            out.print(" ");
            out.println(geometryWidth * 2);
            out.print("TOTALROWBYTES");
            out.print(" ");
            out.println(geometryWidth * 2);
            out.print("BANDGAPBYTES");
            out.print(" ");
            out.println(0);
            out.print("NODATA");
            out.print(" ");
            out.println(-9999);
            out.print("ULXMAP");
            out.print(" ");
            out.println(xUpperLeft);
            out.print("ULYMAP");
            out.print(" ");
            out.println(yUpperLeft);
            out.print("XDIM");
            out.print(" ");
            out.println(geospatialDx);
            out.print("YDIM");
            out.print(" ");
            out.println(geospatialDy);
            out.flush();
            out.close();
        } else {
            ZipOutputStream outZ = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(gc.getName().toString() + ".HDR");
            outZ.putNextEntry(e);
            outZ.write("BYTEORDER".getBytes());
            outZ.write(" ".getBytes());
            outZ.write("M".getBytes());
            outZ.write("\n".getBytes());
            outZ.write("LAYoutZ".getBytes());
            outZ.write(" ".getBytes());
            outZ.write("BIL".getBytes());
            outZ.write("\n".getBytes());
            outZ.write("NROWS".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Integer.toString(geometryHeight).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("NCOLS".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Integer.toString(geometryWidth).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("NBANDS".getBytes());
            outZ.write(" ".getBytes());
            outZ.write("1".getBytes());
            outZ.write("\n".getBytes());
            outZ.write("NBITS".getBytes());
            outZ.write(" ".getBytes());
            outZ.write("16".getBytes());
            outZ.write("\n".getBytes());
            outZ.write("BANDROWBYTES".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Integer.toString(geometryWidth * 2).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("TOTALROWBYTES".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Integer.toString(geometryWidth * 2).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("BANDGAPBYTES".getBytes());
            outZ.write(" ".getBytes());
            outZ.write("0".getBytes());
            outZ.write("\n".getBytes());
            outZ.write("NODATA".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Integer.toString(-9999).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("ULXMAP".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Double.toString(xUpperLeft + geospatialDx / 2.0).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("ULYMAP".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Double.toString(yUpperLeft - geospatialDy / 2.0).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("XDIM".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Double.toString(geospatialDx).getBytes());
            outZ.write("\n".getBytes());
            outZ.write("YDIM".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(Double.toString(geospatialDy).toString().getBytes());
            outZ.write("\n".getBytes());
            outZ.closeEntry();
            ((ZipOutputStream)dest).closeEntry();
        }
    }

    private void writeSRC(GridCoverage2D gc, String name, Object dest) throws FileNotFoundException, IOException {
        gc = gc.geophysics(false);
        ImageOutputStream out = null;
        RenderedImage image = gc.getRenderedImage();
        if (dest instanceof File) {
            File file = new File((File)dest, new StringBuffer(name).append(".SRC").toString());
            out = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)file);
        } else {
            ZipOutputStream outZ = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(gc.getName().toString() + ".SRC");
            outZ.putNextEntry(e);
            out = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outZ);
        }
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        image = this.untileImage(image);
        ParameterBlockJAI pbj = new ParameterBlockJAI("imagewrite");
        pbj.addSource((Object)image);
        pbj.setParameter("Format", (Object)"raw");
        pbj.setParameter("Output", (Object)out);
        RenderedOp wOp = JAI.create((String)"ImageWrite", (ParameterBlock)pbj);
        Object o = wOp.getProperty("JAI.ImageWriter");
        if (o instanceof ImageWriter) {
            ((ImageWriter)o).dispose();
        }
        if (!(dest instanceof File)) {
            ((ZipOutputStream)dest).closeEntry();
        }
        out.flush();
        out.close();
    }

    private void writeGIF(GridCoverage2D gc, String name, Object dest) throws IOException {
        ImageOutputStream out = null;
        GridCoverage2D gc1 = this.rescaleCoverage(gc);
        GridCoverage2D gc2 = gc1.geophysics(false);
        RenderedImage image = gc2.getRenderedImage();
        if (dest instanceof File) {
            File file = new File((File)dest, new StringBuffer(name).append(".GIF").toString());
            out = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)file);
        } else {
            ZipOutputStream outZ = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(gc.getName().toString() + ".GIF");
            outZ.putNextEntry(e);
            out = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outZ);
        }
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageWrite");
        pbj.addSource((Object)image);
        pbj.setParameter("Output", (Object)out);
        pbj.setParameter("Format", (Object)"gif");
        JAI.create((String)"ImageWrite", (ParameterBlock)pbj, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
        if (dest instanceof File) {
            out.close();
        } else {
            out.flush();
            ((ZipOutputStream)dest).closeEntry();
        }
        gc1.dispose(false);
    }

    private GridCoverage2D rescaleCoverage(GridCoverage2D gc) {
        RenderedImage image = gc.getRenderedImage();
        int width = image.getWidth();
        int height = image.getHeight();
        if (height < 480 && width < 640) {
            return gc;
        }
        GeneralGridEnvelope newGridrange = new GeneralGridEnvelope(new int[]{0, 0}, new int[]{640, 480});
        GridGeometry2D newGridGeometry = new GridGeometry2D((GridEnvelope)newGridrange, gc.getEnvelope());
        ParameterValueGroup pvg = resampleFactory.getParameters();
        pvg.parameter("Source").setValue((Object)gc);
        pvg.parameter("GridGeometry").setValue((Object)newGridGeometry);
        pvg.parameter("InterpolationType").setValue((Object)new InterpolationBilinear());
        return (GridCoverage2D)resampleFactory.doOperation(pvg, this.hints);
    }

    private void writePRJ(GridCoverage2D gc, String name, Object dest) throws IOException {
        if (dest instanceof File) {
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(new File((File)dest, new StringBuffer(name).append(".PRJ").toString())));
            fileWriter.write(gc.getCoordinateReferenceSystem().toWKT());
            fileWriter.close();
        } else {
            ZipOutputStream out = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(new StringBuffer(gc.getName().toString()).append(".PRJ").toString());
            out.putNextEntry(e);
            out.write(gc.getCoordinateReferenceSystem().toWKT().getBytes());
            out.closeEntry();
        }
    }

    private void writeStats(PlanarImage image, String name, Object dest, GridCoverage2D gc) throws IOException {
        ParameterBlock pb = new ParameterBlock();
        double[] Max = new double[]{32767.0};
        double[] Min = new double[]{-32768.0};
        pb.addSource(image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        pb.add(new int[]{(int)(Max[0] - Min[0] + 1.0)});
        pb.add(Min);
        pb.add(Max);
        pb.add(1);
        RenderedOp histogramImage = JAI.create((String)"histogram", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
        Histogram hist = (Histogram)histogramImage.getProperty("histogram");
        pb.removeParameters();
        pb.removeSources();
        if (dest instanceof File) {
            if (dest instanceof File) {
                dest = new File((File)dest, new StringBuffer(name).append(".STX").toString());
            }
            PrintWriter p = new PrintWriter(new FileOutputStream((File)dest));
            p.print(1);
            p.print(" ");
            p.print((int)Min[0]);
            p.print(" ");
            p.print((int)Max[0]);
            p.print(" ");
            p.print(hist.getMean()[0]);
            p.print(" ");
            p.print(hist.getStandardDeviation()[0]);
            p.close();
        } else {
            ZipOutputStream outZ = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(name + ".STX");
            outZ.putNextEntry(e);
            outZ.write("1".getBytes());
            outZ.write(" ".getBytes());
            outZ.write(new Integer((int)Min[0]).toString().getBytes());
            outZ.write(" ".getBytes());
            outZ.write(new Integer((int)Max[0]).toString().getBytes());
            outZ.write(" ".getBytes());
            outZ.write(new Double(hist.getMean()[0]).toString().getBytes());
            outZ.write(" ".getBytes());
            outZ.write(new Double(hist.getStandardDeviation()[0]).toString().getBytes());
            ((ZipOutputStream)dest).closeEntry();
        }
        histogramImage.dispose();
    }

    private void writeWorldFile(GridCoverage2D gc, String name, Object dest) throws IOException {
        double yLoc;
        AffineTransform gridToWorld = (AffineTransform)gc.getGridGeometry().getGridToCRS2D();
        boolean lonFirst = XAffineTransform.getSwapXY((AffineTransform)gridToWorld) != -1;
        double xPixelSize = lonFirst ? gridToWorld.getScaleX() : gridToWorld.getShearY();
        double rotation1 = lonFirst ? gridToWorld.getShearX() : gridToWorld.getScaleY();
        double rotation2 = lonFirst ? gridToWorld.getShearY() : gridToWorld.getScaleX();
        double yPixelSize = lonFirst ? gridToWorld.getScaleY() : gridToWorld.getShearX();
        double xLoc = lonFirst ? gridToWorld.getTranslateX() : gridToWorld.getTranslateY();
        double d = yLoc = lonFirst ? gridToWorld.getTranslateY() : gridToWorld.getTranslateX();
        if (dest instanceof File) {
            dest = new File((File)dest, new StringBuffer(name).append(".DMW").toString());
            PrintWriter out = new PrintWriter(new FileOutputStream((File)dest));
            out.println(xPixelSize);
            out.println(rotation1);
            out.println(rotation2);
            out.println(yPixelSize);
            out.println(xLoc);
            out.println(yLoc);
            out.close();
        } else {
            ZipOutputStream outZ = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(gc.getName().toString() + ".DMW");
            outZ.putNextEntry(e);
            outZ.write(Double.toString(xPixelSize).getBytes());
            outZ.write("\n".getBytes());
            outZ.write(Double.toString(rotation1).toString().getBytes());
            outZ.write("\n".getBytes());
            outZ.write(Double.toString(rotation2).toString().getBytes());
            outZ.write("\n".getBytes());
            outZ.write(Double.toString(xPixelSize).toString().getBytes());
            outZ.write("\n".getBytes());
            outZ.write(Double.toString(yPixelSize).toString().getBytes());
            outZ.write("\n".getBytes());
            outZ.write(Double.toString(xLoc).toString().getBytes());
            outZ.write("\n".getBytes());
            outZ.write(Double.toString(yLoc).toString().getBytes());
            outZ.write("\n".getBytes());
            ((ZipOutputStream)dest).closeEntry();
        }
    }

    private void writeDEM(PlanarImage image, String name, Object dest) throws FileNotFoundException, IOException {
        ImageOutputStream out;
        if (dest instanceof File) {
            dest = new File((File)dest, new StringBuffer(name).append(".DEM").toString());
            out = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)((File)dest));
        } else {
            ZipOutputStream outZ = (ZipOutputStream)dest;
            ZipEntry e = new ZipEntry(name + ".DEM");
            outZ.putNextEntry(e);
            out = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outZ);
        }
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        image = this.untileImage((RenderedImage)image);
        ParameterBlockJAI pbjW = new ParameterBlockJAI("ImageWrite");
        pbjW.addSource((Object)image);
        pbjW.setParameter("Format", (Object)"raw");
        pbjW.setParameter("Output", (Object)out);
        JAI.create((String)"ImageWrite", (ParameterBlock)pbjW);
        if (dest instanceof File) {
            out.flush();
            out.close();
        } else {
            ((ZipOutputStream)dest).closeEntry();
        }
    }

    private PlanarImage untileImage(RenderedImage image) {
        ParameterBlockJAI pbj = new ParameterBlockJAI("format");
        pbj.addSource((Object)image);
        pbj.setParameter("dataType", image.getSampleModel().getTransferType());
        ImageLayout layout = new ImageLayout(image);
        layout.unsetTileLayout();
        layout.setTileGridXOffset(0);
        layout.setTileGridYOffset(0);
        layout.setTileHeight(image.getHeight());
        layout.setTileWidth(image.getWidth());
        layout.setValid(240);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return JAI.create((String)"format", (ParameterBlock)pbj, (RenderingHints)hints);
    }

    static {
        NoDataReplacerOpImage.register(JAI.getDefaultInstance());
        sdFactory = new SelectSampleDimension();
        resampleFactory = new Resample();
    }
}

