/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccess;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessDB2;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessMySql;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessOracle;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessPostGis;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessUniversal;
import org.geotools.gce.imagemosaic.jdbc.SpatialExtension;
import org.geotools.gce.imagemosaic.jdbc.custom.JDBCAccessOracleGeoRaster;

class JDBCAccessFactory {
    static Map<String, JDBCAccess> JDBCAccessMap = new HashMap<String, JDBCAccess>();

    JDBCAccessFactory() {
    }

    static synchronized JDBCAccess getJDBCAcess(Config config) throws Exception {
        JDBCAccess jdbcAccess = JDBCAccessMap.get(config.getXmlUrl());
        if (jdbcAccess != null) {
            return jdbcAccess;
        }
        SpatialExtension type = config.getSpatialExtension();
        if (type == null) {
            throw new Exception("Property <spatialExtension> missing");
        }
        if (type == SpatialExtension.DB2) {
            jdbcAccess = new JDBCAccessDB2(config);
        } else if (type == SpatialExtension.POSTGIS) {
            jdbcAccess = new JDBCAccessPostGis(config);
        } else if (type == SpatialExtension.MYSQL) {
            jdbcAccess = new JDBCAccessMySql(config);
        } else if (type == SpatialExtension.UNIVERSAL) {
            jdbcAccess = new JDBCAccessUniversal(config);
        } else if (type == SpatialExtension.ORACLE) {
            jdbcAccess = new JDBCAccessOracle(config);
        } else if (type == SpatialExtension.GEORASTER) {
            jdbcAccess = new JDBCAccessOracleGeoRaster(config);
        } else if (type == SpatialExtension.CUSTOM) {
            String jdbcAccessClassName = config.getJdbcAccessClassName();
            Class<?> jdbcAccessClass = Class.forName(jdbcAccessClassName);
            try {
                Constructor<?> cons = jdbcAccessClass.getConstructor(Config.class);
                jdbcAccess = (JDBCAccess)cons.newInstance(config);
            }
            catch (Exception ex) {
                String msg = "No public Constructor with an " + config.getClass().getName() + " argument for class " + jdbcAccessClassName;
                throw new RuntimeException(msg, ex);
            }
        } else {
            throw new Exception("spatialExtension: " + (Object)((Object)type) + " not supported");
        }
        jdbcAccess.initialize();
        JDBCAccessMap.put(config.getXmlUrl(), jdbcAccess);
        return jdbcAccess;
    }
}

