/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.jdbc.ImageMosaicJDBCReader;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class ImageMosaicJDBCFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logger.getLogger(ImageMosaicJDBCFormat.class.getPackage().getName());
    public static final DefaultParameterDescriptor OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);

    public ImageMosaicJDBCFormat() {
        this.setInfo();
    }

    public static URL getURLFromSource(Object source) {
        if (source == null) {
            return null;
        }
        URL sourceURL = null;
        try {
            if (source instanceof File) {
                sourceURL = ((File)source).toURI().toURL();
            } else if (source instanceof URL) {
                sourceURL = (URL)source;
            } else if (source instanceof String) {
                File tempFile = new File((String)source);
                sourceURL = tempFile.exists() ? tempFile.toURI().toURL() : new URL(URLDecoder.decode((String)source, "UTF8"));
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        return sourceURL;
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaicJDBC");
        info.put("description", "Image mosaicking/pyramidal jdbc plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, OUTPUT_TRANSPARENT_COLOR}));
        this.writeParameters = null;
    }

    public ImageMosaicJDBCReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    public boolean accepts(Object source) {
        if (source == null) {
            return false;
        }
        URL sourceUrl = ImageMosaicJDBCFormat.getURLFromSource(source);
        if (sourceUrl == null) {
            return false;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int c;
            InputStream in = (InputStream)sourceUrl.getContent();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return out.toString().indexOf("coverageName") != -1;
    }

    public ImageMosaicJDBCReader getReader(Object source, Hints hints) {
        try {
            return new ImageMosaicJDBCReader(source, hints);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

