/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Map;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDialect
extends BasicSQLDialect {
    public SQLServerDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return !"INFORMATION_SCHEMA".equals(schemaName) && !"sys".equals(schemaName);
    }

    public String getGeometryTypeName(Integer type) {
        return "geometry";
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Date.class, 93);
        mappings.put(Time.class, 93);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("geometry", Geometry.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(12, "varchar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ");
        this.encodeColumnName(columnName, sql);
        sql.append(".STSrid");
        sql.append(" FROM ");
        this.encodeTableName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(columnName, sql);
        sql.append(" IS NOT NULL");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block8: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block8;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = -1;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        sql.append("CAST(");
        this.encodeColumnName(gatt.getLocalName(), sql);
        sql.append(".STSrid as VARCHAR)");
        sql.append(" + ':' + ");
        this.encodeColumnName(gatt.getLocalName(), sql);
        sql.append(".STAsText()");
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        if (value == null) {
            sql.append("NULL");
            return;
        }
        sql.append("geometry::STGeomFromText('").append(value.toText()).append("',").append(srid).append(")");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        String s = rs.getString(column);
        return this.decodeGeometry(s, factory);
    }

    Geometry decodeGeometry(String s, GeometryFactory factory) throws IOException {
        CoordinateReferenceSystem crs;
        if (s == null) {
            return null;
        }
        if (factory == null) {
            factory = new GeometryFactory();
        }
        String[] split = s.split(":");
        String srid = split[0];
        Geometry g = null;
        try {
            g = new WKTReader(factory).read(split[1]);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
        try {
            crs = CRS.decode((String)("EPSG:" + srid));
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
        g.setUserData((Object)crs);
        return g;
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("CAST(");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(".STSrid as VARCHAR)");
        sql.append(" + ':' + ");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(".STEnvelope().ToString()");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        String s = rs.getString(column);
        Geometry g = this.decodeGeometry(s, null);
        if (g == null) {
            return null;
        }
        return new ReferencedEnvelope(g.getEnvelopeInternal(), (CoordinateReferenceSystem)g.getUserData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" IDENT_CURRENT('").append(tableName).append("')");
        sql.append(" + ");
        sql.append(" IDENT_INCR('").append(tableName).append("')");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                rs.next();
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }
}

