/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCDateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCDateTest
extends JDBCTestSupport {
    protected abstract JDBCDateTestSetup createTestSetup();

    public void testMappings() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("dates"));
        JDBCDateTest.assertEquals(Date.class, (Object)ft.getDescriptor(this.aname("d")).getType().getBinding());
        JDBCDateTest.assertEquals(Timestamp.class, (Object)ft.getDescriptor(this.aname("dt")).getType().getBinding());
        JDBCDateTest.assertEquals(Time.class, (Object)ft.getDescriptor(this.aname("t")).getType().getBinding());
    }

    public void testFiltersByDate() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property(this.aname("d")), (Expression)ff.literal((Object)"2009-06-28"));
        JDBCDateTest.assertEquals((int)2, (int)fs.getCount((Query)new DefaultQuery(this.tname("dates"), (Filter)f)));
        f = ff.lessOrEqual((Expression)ff.property(this.aname("d")), (Expression)ff.literal((Object)new SimpleDateFormat("yyyy-dd-MM").parse("2009-28-06")));
        JDBCDateTest.assertEquals((int)2, (int)fs.getCount((Query)new DefaultQuery(this.tname("dates"), (Filter)f)));
    }

    public void testFilterByTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)"2009-06-28 15:12:41"));
        JDBCDateTest.assertEquals((int)1, (int)fs.getCount((Query)new DefaultQuery(this.tname("dates"), (Filter)f)));
        f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)new SimpleDateFormat("HH:mm:ss,dd-yyyy-MM").parse("15:12:41,28-2009-06")));
        JDBCDateTest.assertEquals((int)1, (int)fs.getCount((Query)new DefaultQuery(this.tname("dates"), (Filter)f)));
    }

    public void testFilterByTime() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsGreaterThanOrEqualTo f = ff.greaterOrEqual((Expression)ff.property(this.aname("t")), (Expression)ff.literal((Object)"13:10:12"));
        JDBCDateTest.assertEquals((int)3, (int)fs.getCount((Query)new DefaultQuery(this.tname("dates"), (Filter)f)));
        f = ff.greaterOrEqual((Expression)ff.property(this.aname("t")), (Expression)ff.literal((Object)new SimpleDateFormat("ss:HH:mm").parse("12:13:10")));
        JDBCDateTest.assertEquals((int)3, (int)fs.getCount((Query)new DefaultQuery(this.tname("dates"), (Filter)f)));
    }
}

