/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.util.Iterator;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;

public abstract class JDBCFeatureSourceTest
extends JDBCTestSupport {
    ContentFeatureSource featureSource;

    protected void setUp() throws Exception {
        super.setUp();
        this.featureSource = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.featureSource.getSchema();
        JDBCFeatureSourceTest.assertEquals((String)this.tname("ft1"), (String)schema.getTypeName());
        JDBCFeatureSourceTest.assertEquals((String)this.dataStore.getNamespaceURI(), (String)schema.getName().getNamespaceURI());
        JDBCFeatureSourceTest.assertTrue((boolean)this.areCRSEqual(CRS.decode((String)"EPSG:4326"), schema.getCoordinateReferenceSystem()));
        JDBCFeatureSourceTest.assertEquals((int)4, (int)schema.getAttributeCount());
        JDBCFeatureSourceTest.assertNotNull((Object)schema.getDescriptor(this.aname("geometry")));
        JDBCFeatureSourceTest.assertNotNull((Object)schema.getDescriptor(this.aname("intProperty")));
        JDBCFeatureSourceTest.assertNotNull((Object)schema.getDescriptor(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertNotNull((Object)schema.getDescriptor(this.aname("doubleProperty")));
    }

    public void testBounds() throws Exception {
        ReferencedEnvelope bounds = this.featureSource.getBounds();
        JDBCFeatureSourceTest.assertEquals((long)0L, (long)Math.round(bounds.getMinX()));
        JDBCFeatureSourceTest.assertEquals((long)0L, (long)Math.round(bounds.getMinY()));
        JDBCFeatureSourceTest.assertEquals((long)2L, (long)Math.round(bounds.getMaxX()));
        JDBCFeatureSourceTest.assertEquals((long)2L, (long)Math.round(bounds.getMaxY()));
        JDBCFeatureSourceTest.assertTrue((boolean)this.areCRSEqual(CRS.decode((String)"EPSG:4326"), bounds.getCoordinateReferenceSystem()));
    }

    public void testBoundsWithQuery() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        DefaultQuery query = new DefaultQuery();
        query.setFilter((Filter)filter);
        ReferencedEnvelope bounds = this.featureSource.getBounds((Query)query);
        JDBCFeatureSourceTest.assertEquals((long)1L, (long)Math.round(bounds.getMinX()));
        JDBCFeatureSourceTest.assertEquals((long)1L, (long)Math.round(bounds.getMinY()));
        JDBCFeatureSourceTest.assertEquals((long)1L, (long)Math.round(bounds.getMaxX()));
        JDBCFeatureSourceTest.assertEquals((long)1L, (long)Math.round(bounds.getMaxY()));
        JDBCFeatureSourceTest.assertTrue((boolean)this.areCRSEqual(CRS.decode((String)"EPSG:4326"), bounds.getCoordinateReferenceSystem()));
    }

    public void testCount() throws Exception {
        JDBCFeatureSourceTest.assertEquals((int)3, (int)this.featureSource.getCount(Query.ALL));
    }

    public void testCountWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        DefaultQuery query = new DefaultQuery();
        query.setFilter((Filter)filter);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)this.featureSource.getCount((Query)query));
    }

    public void testCountWithOffsetLimit() throws Exception {
        DefaultQuery query = new DefaultQuery();
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)this.featureSource.getCount((Query)query));
    }

    public void testGetFeatures() throws Exception {
        ContentFeatureCollection features = this.featureSource.getFeatures();
        JDBCFeatureSourceTest.assertEquals((int)3, (int)features.size());
    }

    public void testGetFeaturesWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)features.size());
        Iterator iterator = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        SimpleFeature feature = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"one", (Object)feature.getAttribute(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertEquals((Object)new Double(1.1), (Object)feature.getAttribute(this.aname("doubleProperty")));
        features.close(iterator);
    }

    public void testGetFeaturesWithInvalidFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try {
            FeatureIterator fi = this.featureSource.getFeatures((Filter)f).features();
            fi.close();
            JDBCFeatureSourceTest.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testGetFeaturesWithLogicFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        BBOX bbox = ff.bbox(this.aname("geometry"), -20.0, -20.0, 20.0, 20.0, "EPSG:4326");
        And filter = ff.and((Filter)property, (Filter)bbox);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)features.size());
        Iterator iterator = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        SimpleFeature feature = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"one", (Object)feature.getAttribute(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertEquals((Object)new Double(1.1), (Object)feature.getAttribute(this.aname("doubleProperty")));
        features.close(iterator);
    }

    public void testCaseInsensitiveFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo sensitive = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"OnE"), true);
        PropertyIsEqualTo insensitive = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"OnE"), false);
        JDBCFeatureSourceTest.assertEquals((int)0, (int)this.featureSource.getCount((Query)new DefaultQuery(null, (Filter)sensitive)));
        JDBCFeatureSourceTest.assertEquals((int)1, (int)this.featureSource.getCount((Query)new DefaultQuery(null, (Filter)insensitive)));
    }

    public void testGetFeaturesWithQuery() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        DefaultQuery query = new DefaultQuery();
        query.setPropertyNames(new String[]{this.aname("doubleProperty"), this.aname("intProperty")});
        query.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures((Query)query);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)features.size());
        Iterator iterator = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        SimpleFeature feature = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((int)2, (int)feature.getAttributeCount());
        JDBCFeatureSourceTest.assertEquals((Object)new Double(1.1), (Object)feature.getAttribute(this.aname("doubleProperty")));
        JDBCFeatureSourceTest.assertNotNull((Object)feature.getAttribute(this.aname("intProperty")));
        features.close(iterator);
    }

    public void testGetFeaturesWithInvalidQuery() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try {
            FeatureIterator fi = this.featureSource.getFeatures((Query)new DefaultQuery("ft1", (Filter)f)).features();
            fi.close();
            JDBCFeatureSourceTest.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testGetFeaturesWithSort() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        SortBy sort = ff.sort(this.aname("stringProperty"), SortOrder.ASCENDING);
        DefaultQuery query = new DefaultQuery();
        query.setSortBy(new SortBy[]{sort});
        ContentFeatureCollection features = this.featureSource.getFeatures((Query)query);
        JDBCFeatureSourceTest.assertEquals((int)3, (int)features.size());
        Iterator iterator = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        SimpleFeature f = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"one", (Object)f.getAttribute(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        f = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        f = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"zero", (Object)f.getAttribute(this.aname("stringProperty")));
        features.close(iterator);
        sort = ff.sort(this.aname("stringProperty"), SortOrder.DESCENDING);
        query.setSortBy(new SortBy[]{sort});
        features = this.featureSource.getFeatures((Query)query);
        iterator = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        f = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"zero", (Object)f.getAttribute(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        f = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
        JDBCFeatureSourceTest.assertTrue((boolean)iterator.hasNext());
        f = (SimpleFeature)iterator.next();
        JDBCFeatureSourceTest.assertEquals((Object)"one", (Object)f.getAttribute(this.aname("stringProperty")));
        features.close(iterator);
    }

    public void testGetFeaturesWithMax() throws Exception {
        DefaultQuery q = new DefaultQuery(this.featureSource.getSchema().getTypeName());
        q.setMaxFeatures(2);
        ContentFeatureCollection features = this.featureSource.getFeatures((Query)q);
        JDBCFeatureSourceTest.assertEquals((int)2, (int)features.size());
        Iterator it = features.iterator();
        int count = 0;
        ReferencedEnvelope env = new ReferencedEnvelope(((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem());
        while (it.hasNext()) {
            SimpleFeature f = (SimpleFeature)it.next();
            env.expandToInclude((Envelope)ReferencedEnvelope.reference((BoundingBox)f.getBounds()));
            ++count;
        }
        JDBCFeatureSourceTest.assertEquals((int)2, (int)count);
        features.close(it);
        JDBCFeatureSourceTest.assertTrue((boolean)this.areReferencedEnvelopesEuqal(env, features.getBounds()));
    }

    public void testGetFeaturesWithOffset() throws Exception {
        DefaultQuery q = new DefaultQuery(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{this.dataStore.getFilterFactory().sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        q.setStartIndex(Integer.valueOf(2));
        ContentFeatureCollection features = this.featureSource.getFeatures((Query)q);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)features.size());
        Iterator it = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)it.hasNext());
        SimpleFeature f = (SimpleFeature)it.next();
        ReferencedEnvelope fe = ReferencedEnvelope.reference((BoundingBox)f.getBounds());
        JDBCFeatureSourceTest.assertEquals((int)2, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
        JDBCFeatureSourceTest.assertFalse((boolean)it.hasNext());
        features.close(it);
        JDBCFeatureSourceTest.assertTrue((boolean)this.areReferencedEnvelopesEuqal(fe, features.getBounds()));
    }

    public void testGetFeaturesWithOffsetLimit() throws Exception {
        DefaultQuery q = new DefaultQuery(this.featureSource.getSchema().getTypeName());
        q.setStartIndex(Integer.valueOf(1));
        q.setMaxFeatures(1);
        ContentFeatureCollection features = this.featureSource.getFeatures((Query)q);
        JDBCFeatureSourceTest.assertEquals((int)1, (int)features.size());
        Iterator it = features.iterator();
        JDBCFeatureSourceTest.assertTrue((boolean)it.hasNext());
        SimpleFeature f = (SimpleFeature)it.next();
        ReferencedEnvelope fe = ReferencedEnvelope.reference((BoundingBox)f.getBounds());
        JDBCFeatureSourceTest.assertEquals((int)1, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
        JDBCFeatureSourceTest.assertFalse((boolean)it.hasNext());
        features.close(it);
        JDBCFeatureSourceTest.assertTrue((boolean)this.areReferencedEnvelopesEuqal(fe, features.getBounds()));
    }

    public void testRendererBehaviour() throws Exception {
        DefaultQuery query = new DefaultQuery(this.featureSource.getSchema().getTypeName());
        query.setHints(new Hints((RenderingHints)new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory())));
        ContentFeatureCollection fc = this.featureSource.getFeatures((Query)query);
        FeatureIterator fi = fc.features();
        while (fi.hasNext()) {
            fi.next();
        }
        fi.close();
    }

    public void testQueryCapabilitiesSort() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        QueryCapabilities caps = this.featureSource.getQueryCapabilities();
        JDBCFeatureSourceTest.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)}));
        JDBCFeatureSourceTest.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("stringProperty"), SortOrder.DESCENDING)}));
        JDBCFeatureSourceTest.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("doubleProperty"), SortOrder.ASCENDING)}));
        JDBCFeatureSourceTest.assertFalse((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("geometry"), SortOrder.ASCENDING)}));
    }

    public void testQueryCapabilitiesReliableFid() throws Exception {
        QueryCapabilities caps = this.featureSource.getQueryCapabilities();
        JDBCFeatureSourceTest.assertTrue((boolean)caps.isReliableFIDSupported());
    }

    public void testNaturalSortingAsc() throws Exception {
        DefaultQuery q = new DefaultQuery(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        FeatureIterator features = this.featureSource.getFeatures((Query)q).features();
        String prevId = null;
        while (features.hasNext()) {
            String currId = ((SimpleFeature)features.next()).getID();
            if (prevId != null) {
                JDBCFeatureSourceTest.assertTrue((prevId.compareTo(currId) <= 0 ? 1 : 0) != 0);
            }
            prevId = currId;
        }
        features.close();
    }

    public void testNaturalSortingdesc() throws Exception {
        DefaultQuery q = new DefaultQuery(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        FeatureIterator features = this.featureSource.getFeatures((Query)q).features();
        String prevId = null;
        while (features.hasNext()) {
            String currId = ((SimpleFeature)features.next()).getID();
            if (prevId != null) {
                JDBCFeatureSourceTest.assertTrue((prevId.compareTo(currId) >= 0 ? 1 : 0) != 0);
            }
            prevId = currId;
        }
        features.close();
    }
}

