/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Collections;
import org.geotools.data.FeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCPrimaryKeyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public abstract class JDBCPrimaryKeyTest
extends JDBCTestSupport {
    protected abstract JDBCPrimaryKeyTestSetup createTestSetup();

    protected void setUp() throws Exception {
        super.setUp();
        this.dataStore.setDatabaseSchema(null);
    }

    public void testAutoGeneratedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("auto"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof AutoGeneratedPrimaryKeyColumn));
        JDBCPrimaryKeyTest.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testSequencedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("seq"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof SequencedPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testNonIncrementingPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    void addFeature(SimpleFeatureType featureType, FeatureCollection features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.add((Object)"four");
        b.add((Object)new GeometryFactory().createPoint(new Coordinate(4.0, 4.0)));
        SimpleFeature f = b.buildFeature(null);
        features.add((Feature)f);
        JDBCPrimaryKeyTest.assertTrue((boolean)((String)f.getUserData().get("fid")).matches(this.tname(featureType.getTypeName()) + ".4(\\..*)?"));
    }

    void assertPrimaryKeyValues(FeatureCollection features, int count) throws Exception {
        FeatureIterator i = features.features();
        for (int j = 1; j <= count; ++j) {
            JDBCPrimaryKeyTest.assertTrue((boolean)i.hasNext());
            SimpleFeature f = (SimpleFeature)i.next();
            JDBCPrimaryKeyTest.assertEquals((String)(this.tname(features.getSchema().getName().getLocalPart()) + "." + j), (String)f.getID());
        }
        features.close(i);
    }

    public void testMultiColumnPrimaryKey() throws Exception {
        int j;
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("multi"));
        JDBCPrimaryKeyTest.assertEquals((int)2, (int)fs.getPrimaryKey().getColumns().size());
        ContentFeatureCollection features = fs.getFeatures();
        FeatureIterator i = features.features();
        String[] xyz = new String[]{"x", "y", "z"};
        for (j = 1; j <= 3; ++j) {
            JDBCPrimaryKeyTest.assertTrue((boolean)i.hasNext());
            SimpleFeature f = (SimpleFeature)i.next();
            JDBCPrimaryKeyTest.assertEquals((String)(this.tname("multi") + "." + j + "." + xyz[j - 1]), (String)f.getID());
        }
        features.close(i);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        i = features.features();
        for (j = 0; j < 3; ++j) {
            i.hasNext();
            i.next();
        }
        JDBCPrimaryKeyTest.assertTrue((boolean)i.hasNext());
        SimpleFeature f = (SimpleFeature)i.next();
        JDBCPrimaryKeyTest.assertTrue((boolean)f.getID().startsWith(this.tname("multi") + ".4."));
        features.close(i);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Id id = ff.id(Collections.singleton(ff.featureId(this.tname("multi") + ".1.x")));
        features = fs.getFeatures((Filter)id);
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)features.size());
    }

    public void testNullPrimaryKey() throws Exception {
        JDBCFeatureSource fs = (JDBCFeatureSource)this.dataStore.getFeatureSource(this.tname("nokey"));
        JDBCPrimaryKeyTest.assertFalse((boolean)(fs instanceof FeatureStore));
    }

    public void testUniqueIndex() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("uniq"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        JDBCPrimaryKeyTest.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testExposePrimaryKeyColumns() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        JDBCPrimaryKeyTest.assertEquals((int)2, (int)fs.getSchema().getAttributeCount());
        fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        fs.setExposePrimaryKeyColumns(true);
        JDBCPrimaryKeyTest.assertEquals((int)3, (int)fs.getSchema().getAttributeCount());
    }
}

